/*
 * Decompiled with CFR 0.152.
 */
package enkan.system.devel.command;

import enkan.system.EnkanSystem;
import enkan.system.ReplResponse;
import enkan.system.SystemCommand;
import enkan.system.Transport;
import enkan.system.devel.CompileResult;
import enkan.system.devel.Compiler;
import enkan.system.devel.compiler.MavenCompiler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CompileCommand
implements SystemCommand {
    private final transient Compiler compiler;

    public CompileCommand() {
        this(new MavenCompiler());
    }

    public CompileCommand(Compiler compiler) {
        this.compiler = compiler;
    }

    public boolean execute(EnkanSystem system, Transport transport, String ... args) {
        CompileResult result = this.compiler.execute(transport);
        Throwable exception = result.getExecutionException();
        if (exception == null) {
            transport.sendOut("Finished compiling.");
        } else {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            sw.append("Failed to compile.");
            transport.sendErr(sw.toString(), new ReplResponse.ResponseStatus[0]);
        }
        return true;
    }
}

