/*
 * Decompiled with CFR 0.152.
 */
package enkan.system.devel.command;

import enkan.component.ApplicationComponent;
import enkan.config.ConfigurationLoader;
import enkan.exception.FalteringEnvironmentException;
import enkan.system.EnkanSystem;
import enkan.system.Repl;
import enkan.system.ReplResponse;
import enkan.system.SystemCommand;
import enkan.system.Transport;
import enkan.system.devel.ClassWatcher;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class AutoResetCommand
implements SystemCommand {
    private final Repl repl;

    public AutoResetCommand(Repl repl) {
        this.repl = repl;
    }

    public boolean execute(EnkanSystem system, Transport transport, String ... args) {
        if (this.repl.getBackgorundTask("classWatcher") != null) {
            transport.sendOut("Autoreset is already running.");
            return true;
        }
        ConfigurationLoader loader = this.findConfigurationLoader(system);
        if (loader == null) {
            transport.sendOut("Start an application first.");
            return true;
        }
        try {
            ClassWatcher classWatcher = new ClassWatcher(loader.reloadableFiles().stream().map(File::toPath).collect(Collectors.toSet()), () -> {
                system.stop();
                system.start();
                transport.send(ReplResponse.withOut((String)"Reset automatically"));
            });
            this.repl.addBackgroundTask("classWatcher", (Runnable)classWatcher);
            transport.sendOut("Start to watch modification an application.");
            return true;
        }
        catch (IOException ex) {
            throw new FalteringEnvironmentException((Throwable)ex);
        }
    }

    protected ConfigurationLoader findConfigurationLoader(EnkanSystem system) {
        Optional<ConfigurationLoader> loader = system.getAllComponents().stream().filter(c -> c instanceof ApplicationComponent).map(c -> ((ApplicationComponent)c).getLoader()).filter(Objects::nonNull).findFirst();
        return loader.orElse(null);
    }
}

