/*
 * Decompiled with CFR 0.152.
 */
package enkan.system.devel;

import enkan.exception.FalteringEnvironmentException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ClassWatcher
implements Runnable {
    private WatchService watchService;
    private final ConcurrentHashMap<WatchKey, Path> watchings = new ConcurrentHashMap();
    private final Runnable callback;

    public ClassWatcher(Set<Path> directories, Runnable callback) throws IOException {
        this.callback = callback;
        this.watchService = FileSystems.getDefault().newWatchService();
        directories.forEach(this::registerAll);
    }

    private void registerAll(Path base) {
        try {
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    ClassWatcher.this.register(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new FalteringEnvironmentException((Throwable)ex);
        }
    }

    private void register(Path dir) {
        try {
            if (dir == null) {
                return;
            }
            WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.watchings.put(key, dir);
        }
        catch (IOException ex) {
            throw new FalteringEnvironmentException((Throwable)ex);
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            WatchKey key;
            try {
                key = this.watchService.poll(10L, TimeUnit.SECONDS);
                if (key == null) {
                    continue;
                }
            }
            catch (InterruptedException ex) {
                return;
            }
            boolean changed = false;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> pathEvent = event;
                Path path = this.watchings.get(key).resolve((Path)pathEvent.context());
                if (kind == StandardWatchEventKinds.ENTRY_MODIFY && !path.toFile().isDirectory()) {
                    changed = true;
                }
                if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                if (!path.toFile().isDirectory()) {
                    changed = true;
                }
                if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) continue;
                this.registerAll(path);
            }
            if (changed) {
                this.callback.run();
            }
            if (key.reset()) continue;
            this.watchings.remove(key);
            if (!this.watchings.isEmpty()) continue;
            break;
        }
    }
}

