/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.devel;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.collection.Parameters;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.TraceLog;
import enkan.data.Traceable;
import enkan.endpoint.devel.TraceDetail;
import enkan.endpoint.devel.TraceList;
import enkan.endpoint.devel.TraceRouting;
import enkan.middleware.AbstractWebMiddleware;
import enkan.middleware.session.KeyValueStore;
import enkan.middleware.session.MemoryStore;
import enkan.util.MixinUtils;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.Objects;
import net.unit8.moshas.MoshasEngine;

@Middleware(name="traceWeb")
public class TraceWebMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private LinkedList<LogKey> idList;
    private KeyValueStore store = new MemoryStore();
    private String mountPath = "/x-enkan/requests";
    private TraceRouting traceRouting;
    private long storeSize = 100L;

    public TraceWebMiddleware() {
        this.idList = new LinkedList();
        MoshasEngine moshas = new MoshasEngine();
        TraceList traceList = new TraceList(moshas);
        TraceDetail traceDetail = new TraceDetail(moshas);
        this.traceRouting = new TraceRouting(this.mountPath);
        this.traceRouting.add("/", (req, os) -> traceList.render((OutputStream)os, "logs", this.idList));
        this.traceRouting.add("/[a-z0-9\\-]+", (req, os) -> {
            String id = req.getUri().substring(req.getUri().lastIndexOf("/") + 1);
            RequestLog requestLog = (RequestLog)this.store.read(id);
            LinkedList<ElapseTime> middlewareTraces = new LinkedList<ElapseTime>();
            long t = 0L;
            for (TraceLog.Entry e : requestLog.getInboundLog().getEntries()) {
                if (!middlewareTraces.isEmpty()) {
                    ((ElapseTime)middlewareTraces.getLast()).setInboundElapse(e.getTimestamp() - t);
                }
                t = e.getTimestamp();
                middlewareTraces.add(new ElapseTime(e.getMiddleware()));
            }
            int idx = middlewareTraces.size();
            for (TraceLog.Entry e : requestLog.getOutboundLog().getEntries()) {
                ((ElapseTime)middlewareTraces.get(--idx)).setOutboundElapse(e.getTimestamp() - t);
                t = e.getTimestamp();
            }
            traceDetail.render((OutputStream)os, "headers", requestLog.getHeaders(), "parameters", requestLog.getParameters(), "traces", middlewareTraces);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        if (request.getUri().startsWith(this.mountPath + "/")) {
            return this.traceRouting.handle(request);
        }
        request = (HttpRequest)MixinUtils.mixin((Object)request, (Class[])new Class[]{Traceable.class});
        HttpResponse response = this.castToHttpResponse(chain.next((Object)request));
        Traceable requestTrace = (Traceable)Traceable.class.cast(request);
        Traceable responseTrace = (Traceable)Traceable.class.cast(response);
        TraceWebMiddleware traceWebMiddleware = this;
        synchronized (traceWebMiddleware) {
            if ((long)this.idList.size() >= this.storeSize) {
                LogKey oldestLogKey = this.idList.removeLast();
                this.store.delete(oldestLogKey.getId());
            }
            this.idList.addFirst(new LogKey(requestTrace.getId(), request.getRequestMethod(), request.getUri()));
            this.store.write(requestTrace.getId(), (Serializable)new RequestLog(request.getHeaders(), request.getParams(), requestTrace.getTraceLog(), responseTrace.getTraceLog()));
        }
        this.idList.add(new LogKey(requestTrace.getId(), request.getRequestMethod(), request.getUri()));
        return response;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public void setStoreSize(long storeSize) {
        this.storeSize = storeSize;
    }

    public static class RequestLog
    implements Serializable {
        private Headers headers;
        private Parameters parameters;
        private TraceLog inboundLog;
        private TraceLog outboundLog;

        public RequestLog(Headers headers, Parameters parameters, TraceLog inboundLog, TraceLog outboundLog) {
            this.headers = headers;
            this.parameters = parameters;
            this.inboundLog = inboundLog;
            this.outboundLog = outboundLog;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public TraceLog getInboundLog() {
            return this.inboundLog;
        }

        public TraceLog getOutboundLog() {
            return this.outboundLog;
        }
    }

    public static class LogKey
    implements Serializable,
    Comparable<LogKey> {
        private String id;
        private String method;
        private String uri;
        private LocalDateTime dateTime;

        public LogKey(String id, String method, String uri) {
            this.id = id;
            this.method = method;
            this.uri = uri;
            this.dateTime = LocalDateTime.now();
        }

        public String getId() {
            return this.id;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUri() {
            return this.uri;
        }

        public LocalDateTime getDateTime() {
            return this.dateTime;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object another) {
            return another != null && LogKey.class.isInstance(another) && Objects.equals(this.id, ((LogKey)another).getId());
        }

        @Override
        public int compareTo(LogKey another) {
            return this.dateTime.compareTo(another.getDateTime());
        }
    }

    public static class ElapseTime {
        private Long inbound;
        private Long outbound;
        private String middlewareName;

        public ElapseTime(String middlewareName) {
            this.middlewareName = middlewareName;
        }

        public void setInboundElapse(Long elapse) {
            this.inbound = elapse;
        }

        public void setOutboundElapse(Long elapse) {
            this.outbound = elapse;
        }

        public Long getInboundElapse() {
            return this.inbound;
        }

        public Long getOutboundElapse() {
            return this.outbound;
        }

        public String getMiddlewareName() {
            return this.middlewareName;
        }
    }
}

