/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.devel;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.collection.Headers;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.exception.MisconfigurationException;
import enkan.exception.UnreachableException;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.BeanBuilder;
import enkan.util.HttpResponseUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;
import net.unit8.moshas.MoshasEngine;
import net.unit8.moshas.RenderFunction;
import net.unit8.moshas.RenderUtils;
import net.unit8.moshas.Snippet;
import net.unit8.moshas.Template;
import net.unit8.moshas.ViewLogicDescriber;
import net.unit8.moshas.context.Context;
import net.unit8.moshas.context.IContext;
import net.unit8.moshas.context.WithLocalScope;
import net.unit8.moshas.dom.Node;

@Middleware(name="stacktrace")
public class StacktraceMiddleware<NRES>
extends AbstractWebMiddleware<HttpRequest, NRES> {
    private final MoshasEngine moshas = new MoshasEngine();
    private String primer;
    private final Snippet stackTraceElementSnippet;

    public StacktraceMiddleware() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/css/primer.css"), StandardCharsets.ISO_8859_1));){
            this.primer = reader.lines().collect(Collectors.joining());
        }
        catch (Exception e) {
            this.primer = "";
        }
        this.stackTraceElementSnippet = this.moshas.describe("templates/stacktrace.html", ".trace > table > tbody > tr", (ViewLogicDescriber & Serializable)s -> {
            s.select("td.source", (RenderFunction & Serializable)(el, ctx) -> el.text(ctx.getString(new String[]{"stackTraceElement", "fileName"}) + ":" + ctx.getString(new String[]{"stackTraceElement", "lineNumber"})));
            s.select("td.method", (RenderFunction & Serializable)(el, ctx) -> el.text(ctx.getString(new String[]{"stackTraceElement", "className"}) + "." + ctx.getString(new String[]{"stackTraceElement", "methodName"})));
        });
    }

    protected HttpResponse render(Template template, Object ... args) {
        StringWriter sw = new StringWriter();
        Context ctx = new Context();
        for (int i = 0; i < args.length; i += 2) {
            ctx.setVariable(Objects.toString(args[i], ""), args[i + 1]);
        }
        template.render((IContext)ctx, (Writer)sw);
        HttpResponse response = HttpResponse.of((String)sw.toString());
        HttpResponseUtils.contentType((HttpResponse)response, (String)"text/html");
        return response;
    }

    protected HttpResponse htmlUnreachableExResponse(UnreachableException ex) {
        Template template = this.moshas.describe("templates/unreachable.html", (ViewLogicDescriber & Serializable)t -> {});
        return (HttpResponse)BeanBuilder.builder((Object)this.render(template, new Object[0])).set(HttpResponse::setStatus, (Object)500).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/html; charset=UTF-8")).build();
    }

    protected HttpResponse htmlMisconfigExResponse(MisconfigurationException ex, HttpRequest request) {
        String primer = this.primer;
        Template template = this.moshas.describe("templates/misconfiguration.html", (ViewLogicDescriber & Serializable)t -> {
            t.select("#primer", (RenderFunction & Serializable)(el, ctx) -> el.text(primer));
            t.select(".problem", RenderUtils.text((String[])new String[]{"exception", "problem"}));
            t.select(".solution", RenderUtils.text((String[])new String[]{"exception", "solution"}));
            t.select(".trace table tbody", (RenderFunction & Serializable)(el, ctx) -> {
                el.empty();
                ctx.getCollection(new String[]{"exception", "stackTrace"}).forEach(stel -> ctx.localScope("stackTraceElement", stel, (WithLocalScope & Serializable)() -> el.appendChild((Node)this.stackTraceElementSnippet.render(ctx))));
            });
            t.select(".request .uri", RenderUtils.text((String[])new String[]{"request", "uri"}));
            t.select(".request .server-name", RenderUtils.text((String[])new String[]{"request", "serverName"}));
            t.select(".request .server-port", RenderUtils.text((String[])new String[]{"request", "serverPort"}));
            t.select(".request .remote-addr", RenderUtils.text((String[])new String[]{"request", "remoteAddr"}));
            t.select(".request .parameters", RenderUtils.text((String[])new String[]{"request", "params"}));
        });
        return (HttpResponse)BeanBuilder.builder((Object)this.render(template, "exception", ex, "request", request)).set(HttpResponse::setStatus, (Object)500).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/html; charset=UTF-8")).build();
    }

    protected HttpResponse htmlExResponse(Throwable ex) {
        Template template = this.moshas.describe("templates/stacktrace.html", (ViewLogicDescriber & Serializable)t -> {
            t.select("#class-name", (RenderFunction & Serializable)(el, ctx) -> el.text(ctx.get(new String[]{"exception"}).getClass().getName()));
            t.select(".message", (RenderFunction & Serializable)(el, ctx) -> el.text(ctx.getString(new String[]{"exception", "message"})));
            t.select(".trace table tbody", (RenderFunction & Serializable)(el, ctx) -> {
                el.empty();
                ctx.getCollection(new String[]{"exception", "stackTrace"}).forEach(stel -> ctx.localScope("stackTraceElement", stel, (WithLocalScope & Serializable)() -> el.appendChild((Node)this.stackTraceElementSnippet.render(ctx))));
            });
        });
        return (HttpResponse)BeanBuilder.builder((Object)this.render(template, "exception", ex)).set(HttpResponse::setStatus, (Object)500).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/html; charset=UTF-8")).build();
    }

    protected HttpResponse exResponse(HttpRequest request, Throwable ex) {
        String accept = request.getHeaders().get((Object)"accept");
        if (accept != null && accept.matches("^text/javascript")) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of((String)sw.toString())).set(HttpResponse::setStatus, (Object)500).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/javascript")).build();
        }
        if (ex instanceof UnreachableException) {
            return this.htmlUnreachableExResponse((UnreachableException)ex);
        }
        if (ex instanceof MisconfigurationException) {
            return this.htmlMisconfigExResponse((MisconfigurationException)ex, request);
        }
        return this.htmlExResponse(ex);
    }

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, NRES, ?, ?> chain) {
        try {
            return this.castToHttpResponse(chain.next((Object)request));
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            return this.exResponse(request, t);
        }
    }
}

