/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.devel;

import enkan.MiddlewareChain;
import enkan.annotation.Middleware;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.middleware.AbstractWebMiddleware;
import enkan.util.HttpResponseUtils;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import net.unit8.moshas.MoshasEngine;
import net.unit8.moshas.RenderFunction;
import net.unit8.moshas.RenderUtils;
import net.unit8.moshas.Template;
import net.unit8.moshas.ViewLogicDescriber;
import net.unit8.moshas.context.Context;
import net.unit8.moshas.context.IContext;

@Middleware(name="httpStatusCat", dependencies={"contentType"})
public class HttpStatusCatMiddleware
extends AbstractWebMiddleware<HttpRequest, HttpResponse> {
    private boolean moreCats = false;
    private final MoshasEngine moshas = new MoshasEngine();
    private final Template template = this.moshas.describe("templates/httpStatusCat.html", (ViewLogicDescriber & Serializable)t -> {
        t.select("head > title", RenderUtils.text((String[])new String[]{"status"}));
        t.select("img#cat", (RenderFunction & Serializable)(el, ctx) -> el.attr("src", "//http.cat/" + ctx.getString(new String[]{"status"})));
    });

    public HttpResponse handle(HttpRequest request, MiddlewareChain<HttpRequest, HttpResponse, ?, ?> chain) {
        String type;
        HttpResponse response = this.castToHttpResponse((HttpResponse)chain.next((Object)request));
        if (response != null && (HttpResponseUtils.isEmptyBody((HttpResponse)response) || this.isMoreCats(response)) && ((type = (String)HttpResponseUtils.getHeader((HttpResponse)response, (String)"Content-Type")) == null || "text/html".equals(type))) {
            HttpResponseUtils.header((HttpResponse)response, (String)"Content-Type", (String)"text/html");
            Context context = new Context();
            context.setVariable("status", (Object)response.getStatus());
            StringWriter sw = new StringWriter();
            this.template.render((IContext)context, (Writer)sw);
            response.setBody(sw.toString());
        }
        return response;
    }

    private boolean isMoreCats(HttpResponse response) {
        return this.moreCats && response.getBody() instanceof String && response.getBodyAsString().length() < 256;
    }

    public void setMoreCats(boolean moreCats) {
        this.moreCats = moreCats;
    }
}

