/*
 * Decompiled with CFR 0.152.
 */
package enkan.endpoint.devel;

import enkan.collection.Headers;
import enkan.data.HttpRequest;
import enkan.data.HttpResponse;
import enkan.data.UriAvailable;
import enkan.predicate.PathPredicate;
import enkan.util.BeanBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;

public class TraceRouting {
    private final String baseUri;
    private final List<Route> routes = new ArrayList<Route>();

    public TraceRouting(String baseUri) {
        this.baseUri = baseUri;
    }

    public void add(String path, BiConsumer<HttpRequest, OutputStream> action) {
        this.routes.add(new Route((PathPredicate<HttpRequest>)PathPredicate.GET((String)(this.baseUri + path)), action));
    }

    public HttpResponse handle(HttpRequest request) {
        Optional<Route> found = this.routes.stream().filter(route -> route.predicate.test((UriAvailable)request)).findFirst();
        if (found.isPresent()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            found.get().action.accept(request, baos);
            return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of((InputStream)new ByteArrayInputStream(baos.toByteArray()))).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/html")).build();
        }
        return (HttpResponse)BeanBuilder.builder((Object)HttpResponse.of((String)"Not Found")).set(HttpResponse::setHeaders, (Object)Headers.of((String)"Content-Type", (Object)"text/html")).set(HttpResponse::setStatus, (Object)404).build();
    }

    private static class Route {
        final PathPredicate<HttpRequest> predicate;
        final BiConsumer<HttpRequest, OutputStream> action;

        public Route(PathPredicate<HttpRequest> predicate, BiConsumer<HttpRequest, OutputStream> action) {
            this.predicate = predicate;
            this.action = action;
        }
    }
}

