/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.jpa;

import enkan.Middleware;
import enkan.MiddlewareChain;
import enkan.data.Routable;
import enkan.data.jpa.EntityManageable;
import enkan.exception.MisconfigurationException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;

@enkan.annotation.Middleware(name="nonJtaTransaction", dependencies={"entityManager"})
public class NonJtaTransactionMiddleware<REQ, RES>
implements Middleware<REQ, RES, REQ, RES> {
    private Transactional.TxType getTransactionType(Method m) {
        Transactional transactional = m.getDeclaredAnnotation(Transactional.class);
        return transactional != null ? transactional.value() : null;
    }

    public RES handle(REQ req, MiddlewareChain<REQ, RES, ?, ?> chain) {
        Routable routable;
        Method m;
        Transactional.TxType type;
        EntityManager em = Optional.ofNullable(req).filter(EntityManageable.class::isInstance).map(EntityManageable.class::cast).map(EntityManageable::getEntityManager).orElseThrow(() -> new MisconfigurationException("eclipselink.NOT_ENTITY_MANAGEABLE_REQUEST", new Object[0]));
        if (req instanceof Routable && (type = this.getTransactionType(m = (routable = (Routable)req).getControllerMethod())) != null) {
            em.getTransaction().begin();
            try {
                Object ret = chain.next(req);
                em.getTransaction().commit();
                return (RES)ret;
            }
            catch (Throwable t) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                throw t;
            }
        }
        return (RES)chain.next(req);
    }
}

