/*
 * Decompiled with CFR 0.152.
 */
package enkan.component.freemarker;

import enkan.component.ComponentLifecycle;
import enkan.component.SystemComponent;
import enkan.component.freemarker.ValidatableFormAdapter;
import enkan.data.HttpResponse;
import enkan.exception.MisconfigurationException;
import enkan.util.HttpResponseUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.HTMLOutputFormat;
import freemarker.core.OutputFormat;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.StringModel;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotowari.component.TemplateEngine;
import kotowari.data.TemplatedHttpResponse;
import kotowari.data.Validatable;
import kotowari.io.LazyRenderInputStream;

public class FreemarkerTemplateEngine
extends TemplateEngine {
    private Configuration config;
    private String prefix = "templates";
    private String suffix = ".ftl";
    private ClassLoader classLoader;
    private String encoding = "UTF-8";
    private OutputFormat outputFormat = HTMLOutputFormat.INSTANCE;

    public HttpResponse render(String name, Object ... keyOrVals) {
        TemplatedHttpResponse response = TemplatedHttpResponse.create((String)name, (Object[])keyOrVals);
        response.setBody((Object)new LazyRenderInputStream(() -> {
            try {
                Template template = this.config.getTemplate(name + this.suffix, this.encoding);
                StringWriter writer = new StringWriter();
                template.process((Object)response.getContext(), (Writer)writer);
                return new ByteArrayInputStream(writer.toString().getBytes(this.encoding));
            }
            catch (TemplateException e) {
                throw new MisconfigurationException("freemarker.TEMPLATE", new Object[]{e.getFTLInstructionStack(), e.getMessageWithoutStackTop(), e});
            }
            catch (IOException e) {
                throw new MisconfigurationException("freemarker.TEMPLATE", new Object[]{e.getMessage(), String.format(Locale.US, "Make a template '%s'.", name), e});
            }
        }));
        HttpResponseUtils.contentType((HttpResponse)response, (String)"text/html");
        return response;
    }

    protected ComponentLifecycle lifecycle() {
        return new ComponentLifecycle(){

            public void start(SystemComponent component) {
                if (FreemarkerTemplateEngine.this.classLoader == null) {
                    FreemarkerTemplateEngine.this.classLoader = Thread.currentThread().getContextClassLoader();
                }
                FreemarkerTemplateEngine.this.config = new Configuration(new Version(2, 3, 27));
                ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(FreemarkerTemplateEngine.this.classLoader, FreemarkerTemplateEngine.this.prefix);
                FreemarkerTemplateEngine.this.config.setTemplateLoader((TemplateLoader)classTemplateLoader);
                FreemarkerTemplateEngine.this.config.setOutputFormat(FreemarkerTemplateEngine.this.outputFormat);
                FreemarkerTemplateEngine.this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(new Version(2, 3, 27)){

                    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
                        if (obj instanceof Validatable) {
                            return new ValidatableFormAdapter((Validatable)obj, this);
                        }
                        return super.handleUnknownType(obj);
                    }
                });
            }

            public void stop(SystemComponent component) {
                FreemarkerTemplateEngine.this.config = null;
                FreemarkerTemplateEngine.this.classLoader = null;
            }
        };
    }

    public Object createFunction(Function<List, Object> func) {
        return arguments -> func.apply(arguments.stream().map(arg -> {
            if (arg instanceof BeanModel) {
                return ((StringModel)arg).getWrappedObject();
            }
            return arg;
        }).collect(Collectors.toList()));
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }
}

