/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.tx.KeepAliveLocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;

public final class EnkanLocalTransactionDataSource
implements DataSource {
    private final ThreadLocal<LocalTransactionContext> localTxContextHolder = new ThreadLocal();
    private final DataSource dataSource;

    public EnkanLocalTransactionDataSource(DataSource dataSource) {
        if (dataSource == null) {
            throw new DomaNullPointerException("dataSource");
        }
        this.dataSource = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        return this.getConnectionInternal();
    }

    private Connection getConnectionInternal() throws SQLException {
        LocalTransactionContext context = this.localTxContextHolder.get();
        if (context == null) {
            return this.dataSource.getConnection();
        }
        return context.getConnection();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException("iface must not be null");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && (iface.isAssignableFrom(this.getClass()) || this.dataSource.isWrapperFor(iface));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.dataSource.setLogWriter(pw);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public LocalTransaction getLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new LocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger);
    }

    public KeepAliveLocalTransaction getKeepAliveLocalTransaction(JdbcLogger jdbcLogger, TransactionIsolationLevel transactionIsolationLevel) {
        if (jdbcLogger == null) {
            throw new DomaNullPointerException("jdbcLogger");
        }
        if (transactionIsolationLevel == null) {
            throw new DomaNullPointerException("transactionIsolationLevel");
        }
        return new KeepAliveLocalTransaction(this.dataSource, this.localTxContextHolder, jdbcLogger, transactionIsolationLevel);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }
}

