/*
 * Decompiled with CFR 0.152.
 */
package enkan.middleware.doma2;

import enkan.Middleware;
import enkan.MiddlewareChain;
import enkan.component.doma2.DomaPrividerUtils;
import enkan.component.doma2.DomaProvider;
import enkan.data.Routable;
import enkan.exception.MisconfigurationException;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ConfigSupport;
import org.seasar.doma.jdbc.tx.EnkanLocalTransactionDataSource;
import org.seasar.doma.jdbc.tx.LocalTransactionManager;
import org.seasar.doma.jdbc.tx.TransactionManager;

@enkan.annotation.Middleware(name="domaTransaction")
public class DomaTransactionMiddleware<REQ, RES>
implements Middleware<REQ, RES, REQ, RES> {
    @Inject
    private DomaProvider domaProvider;
    private TransactionManager tm;

    private Transactional.TxType getTransactionType(Method m) {
        Transactional transactional = m.getDeclaredAnnotation(Transactional.class);
        return transactional != null ? transactional.value() : null;
    }

    @PostConstruct
    private void init() {
        Config defaultConfig = DomaPrividerUtils.getDefaultConfig(this.domaProvider);
        DataSource ds = defaultConfig.getDataSource();
        if (ds instanceof EnkanLocalTransactionDataSource) {
            EnkanLocalTransactionDataSource ltds = (EnkanLocalTransactionDataSource)ds;
            this.tm = new LocalTransactionManager(ltds.getLocalTransaction(ConfigSupport.defaultJdbcLogger));
        }
    }

    public RES handle(REQ req, MiddlewareChain<REQ, RES, ?, ?> chain) {
        Routable routable;
        Method m;
        Transactional.TxType type;
        if (req instanceof Routable && (type = this.getTransactionType(m = (routable = (Routable)req).getControllerMethod())) != null) {
            switch (type) {
                case REQUIRED: {
                    return (RES)this.tm.required(() -> chain.next(req));
                }
                case REQUIRES_NEW: {
                    return (RES)this.tm.requiresNew(() -> chain.next(req));
                }
            }
            throw new MisconfigurationException("doma2.UNSUPPORTED_TX_TYPE", new Object[]{type});
        }
        return (RES)chain.next(req);
    }
}

