/*
 * Decompiled with CFR 0.152.
 */
package enkan.component.doma2;

import enkan.component.ComponentLifecycle;
import enkan.component.DataSourceComponent;
import enkan.component.SystemComponent;
import enkan.exception.MisconfigurationException;
import enkan.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ConfigProvider;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;
import org.seasar.doma.jdbc.tx.EnkanLocalTransactionDataSource;
import org.seasar.doma.jdbc.tx.LocalTransactionDataSource;

public class DomaProvider
extends SystemComponent<DomaProvider> {
    private DataSource dataSource;
    private final ConcurrentHashMap<String, Object> daoCache = new ConcurrentHashMap();
    private Config defaultConfig;
    private Dialect dialect;
    private Naming naming = Naming.DEFAULT;
    private boolean useLocalTransaction = true;
    private int maxRows = 0;
    private int fetchSize = 0;
    private int queryTimeout = 0;
    private int batchSize = 0;

    public <T> T getDao(Class<? extends T> daoInterface) {
        return (T)this.daoCache.computeIfAbsent(daoInterface.getName(), key -> ReflectionUtils.tryReflection(() -> {
            Class<?> daoClass;
            try {
                daoClass = Class.forName(daoInterface.getName() + "Impl", true, daoInterface.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new MisconfigurationException("doma2.DAO_IMPL_NOT_FOUND", new Object[]{daoInterface.getName(), ex});
            }
            try {
                Constructor<?> daoConstructor = daoClass.getConstructor(DataSource.class);
                return daoConstructor.newInstance(this.dataSource);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> daoConstructor = daoClass.getConstructor(Config.class);
                return daoConstructor.newInstance(this.defaultConfig);
            }
        }));
    }

    protected ComponentLifecycle<DomaProvider> lifecycle() {
        return new ComponentLifecycle<DomaProvider>(){

            public void start(final DomaProvider component) {
                DataSourceComponent dataSourceComponent = (DataSourceComponent)component.getDependency(DataSourceComponent.class);
                component.dataSource = dataSourceComponent.getDataSource();
                if (DomaProvider.this.useLocalTransaction && !(component.dataSource instanceof LocalTransactionDataSource)) {
                    component.dataSource = new EnkanLocalTransactionDataSource(component.dataSource);
                }
                if (component.dialect == null) {
                    component.dialect = (Dialect)new StandardDialect();
                }
                component.defaultConfig = new Config(){

                    public Naming getNaming() {
                        return component.naming;
                    }

                    public DataSource getDataSource() {
                        return component.dataSource;
                    }

                    public Dialect getDialect() {
                        return component.dialect;
                    }

                    public int getMaxRows() {
                        return component.maxRows;
                    }

                    public int getFetchSize() {
                        return component.fetchSize;
                    }

                    public int getQueryTimeout() {
                        return component.queryTimeout;
                    }

                    public int getBatchSize() {
                        return component.batchSize;
                    }
                };
            }

            public void stop(DomaProvider component) {
                component.dataSource = null;
                DomaProvider.this.daoCache.values().stream().filter(ConfigProvider.class::isInstance).map(ConfigProvider.class::cast).map(ConfigProvider::getConfig).map(Config::getSqlFileRepository).forEach(SqlFileRepository::clearCache);
                DomaProvider.this.daoCache.clear();
            }
        };
    }

    protected Config getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setUseLocalTransaction(boolean useLocalTransaction) {
        this.useLocalTransaction = useLocalTransaction;
    }

    public String toString() {
        return "#DomaProvider {\n  \"dependencies\": " + this.dependenciesToString() + "\n}";
    }
}

