/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.hook.license.migration;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class V1__CreateUserLicense
extends BaseJavaMigration {
    public void migrate(Context context) throws Exception {
        Connection connection = context.getConnection();
        try (Statement stmt = connection.createStatement();){
            DSLContext create = DSL.using((Connection)connection);
            this.createUserLicense(create, stmt);
            this.createLastActivity(create, stmt);
        }
    }

    private void createUserLicense(DSLContext create, Statement stmt) throws SQLException {
        String ddl = create.createTable(DSL.table((String)"user_licenses")).column(DSL.field((String)"user_license_id", (DataType)SQLDataType.BIGINT.identity(true))).column(DSL.field((String)"user_id", (DataType)SQLDataType.BIGINT.nullable(false))).column(DSL.field((String)"license_key", (DataType)SQLDataType.VARBINARY((int)16).nullable(false))).constraints(new Constraint[]{DSL.constraint().primaryKey(new Field[]{DSL.field((String)"user_license_id")}), DSL.constraint().foreignKey(DSL.field((String)"user_id")).references(DSL.table((String)"users"), DSL.field((String)"user_id")), DSL.constraint().unique(new Field[]{DSL.field((String)"license_key")})}).getSQL();
        stmt.execute(ddl);
    }

    private void createLastActivity(DSLContext create, Statement stmt) throws SQLException {
        String ddl = create.createTable(DSL.table((String)"license_last_activities")).column(DSL.field((String)"license_last_activity_id", (DataType)SQLDataType.BIGINT.identity(true))).column(DSL.field((String)"user_license_id", (DataType)SQLDataType.BIGINT.nullable(false))).column(DSL.field((String)"user_agent", (DataType)SQLDataType.VARCHAR((int)255))).column(DSL.field((String)"last_used_at", (DataType)SQLDataType.TIMESTAMP.nullable(false))).constraints(new Constraint[]{DSL.constraint().primaryKey(new Field[]{DSL.field((String)"license_last_activity_id")}), DSL.constraint().unique(new Field[]{DSL.field((String)"user_license_id")})}).getSQL();
        stmt.execute(ddl);
    }
}

