/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.hook.license;

import enkan.collection.Headers;
import enkan.data.Cookie;
import enkan.data.jpa.EntityManageable;
import enkan.util.BeanBuilder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import javax.persistence.EntityManager;
import kotowari.restful.data.RestContext;
import net.unit8.bouncr.entity.User;
import net.unit8.bouncr.hook.Hook;
import net.unit8.bouncr.hook.license.LicenseConfig;
import net.unit8.bouncr.hook.license.LicenseKey;
import net.unit8.bouncr.hook.license.entity.LicenseLastActivity;
import net.unit8.bouncr.hook.license.entity.UserLicense;

public class LicenseUpdateHook
implements Hook<RestContext> {
    private final LicenseConfig config;

    public LicenseUpdateHook(LicenseConfig config) {
        this.config = config;
    }

    public void run(RestContext context) {
        EntityManager em = ((EntityManageable)context.getRequest()).getEntityManager();
        context.getValue(User.class).ifPresent(user -> {
            UserLicense userLicense = context.getValue(UserLicense.class).orElseGet(() -> {
                LicenseKey newLicenseKey = LicenseKey.createNew();
                UserLicense userLic = (UserLicense)BeanBuilder.builder((Object)new UserLicense()).set(UserLicense::setUser, user).set(UserLicense::setLicenseKey, (Object)newLicenseKey.asBytes()).build();
                LicenseLastActivity lastActivity = (LicenseLastActivity)BeanBuilder.builder((Object)new LicenseLastActivity()).set(LicenseLastActivity::setUserLicense, (Object)userLic).set(LicenseLastActivity::setUserAgent, (Object)Optional.ofNullable(context.getRequest().getHeaders()).map(headers -> headers.get((Object)"User-Agent")).map(ua -> ua.substring(0, Math.min(ua.length() - 1, 255))).orElse(null)).set(LicenseLastActivity::setLastUsedAt, (Object)LocalDateTime.now()).build();
                em.persist((Object)userLic);
                em.persist((Object)lastActivity);
                Cookie cookie = Cookie.create((String)this.config.getCookieName(), (String)newLicenseKey.asString());
                ZoneId zone = ZoneId.systemDefault();
                Date expires = Date.from(ZonedDateTime.of(LocalDate.now().plusYears(10L).atTime(0, 0), zone).toInstant());
                cookie.setExpires(expires);
                cookie.setPath("/");
                context.setHeaders(Headers.of((String)"Set-Cookie", (Object)cookie.toHttpString()));
                return userLic;
            });
        });
    }
}

