/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.hook.license;

import enkan.collection.Headers;
import enkan.data.Cookie;
import enkan.data.jpa.EntityManageable;
import enkan.util.ThreadingUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import kotowari.restful.data.RestContext;
import net.unit8.bouncr.hook.Hook;
import net.unit8.bouncr.hook.license.LicenseConfig;
import net.unit8.bouncr.hook.license.LicenseKey;
import net.unit8.bouncr.hook.license.entity.UserLicense;

public class LicenseDeleteHook
implements Hook<RestContext> {
    private LicenseConfig config;

    public LicenseDeleteHook(LicenseConfig config) {
        this.config = config;
    }

    public void run(RestContext context) {
        EntityManager em = ((EntityManageable)context.getRequest()).getEntityManager();
        LicenseKey licenseKey = ThreadingUtils.some((Object)context.getRequest().getCookies(), c -> (Cookie)c.get(this.config.getCookieName()), Cookie::getValue, LicenseKey::new).orElse(null);
        if (licenseKey == null) {
            return;
        }
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(UserLicense.class);
        Root root = query.from(UserLicense.class);
        query.where((Expression)cb.equal((Expression)root.get("licenseKey"), (Object)licenseKey.asBytes()));
        em.createQuery(query).getResultStream().forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
        Cookie cookie = Cookie.create((String)this.config.getCookieName(), (String)licenseKey.asString());
        ZoneId zone = ZoneId.systemDefault();
        Date expires = Date.from(ZonedDateTime.of(LocalDate.now().minusYears(10L).atTime(0, 0), zone).toInstant());
        cookie.setExpires(expires);
        cookie.setPath("/");
        context.setHeaders(Headers.of((String)"Set-Cookie", (Object)cookie.toHttpString()));
    }
}

