/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.bouncr.hook.license;

import enkan.data.Cookie;
import enkan.data.jpa.EntityManageable;
import enkan.util.BeanBuilder;
import enkan.util.jpa.EntityTransactionManager;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import kotowari.restful.data.Problem;
import kotowari.restful.data.RestContext;
import net.unit8.bouncr.entity.User;
import net.unit8.bouncr.hook.Hook;
import net.unit8.bouncr.hook.license.LicenseConfig;
import net.unit8.bouncr.hook.license.LicenseKey;
import net.unit8.bouncr.hook.license.entity.LicenseLastActivity;
import net.unit8.bouncr.hook.license.entity.UserLicense;

public class LicenseCheckHook
implements Hook<RestContext> {
    private static final URI EXCEED_LICENSING_DEVICES = URI.create("/bouncr/problem/EXCEED_LICENSING_DEVICES");
    private LicenseConfig config;

    public LicenseCheckHook(LicenseConfig config) {
        this.config = config;
    }

    private LicenseLastActivity findLastActivity(EntityManager em, UserLicense userLicense) {
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(LicenseLastActivity.class);
        Root root = query.from(LicenseLastActivity.class);
        query.where((Expression)cb.equal((Expression)root.get("userLicense"), (Object)userLicense));
        return em.createQuery(query).getResultStream().findAny().orElse(null);
    }

    public void run(RestContext context) {
        EntityManager em = ((EntityManageable)context.getRequest()).getEntityManager();
        context.getValue(User.class).ifPresent(user -> {
            LicenseKey licenseKey = Optional.ofNullable(context.getRequest().getCookies()).map(c -> (Cookie)c.get(this.config.getCookieName())).map(Cookie::getValue).map(LicenseKey::new).orElse(null);
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(UserLicense.class);
            Root root = query.from(UserLicense.class);
            query.where((Expression)cb.equal((Expression)root.get("user"), user));
            List licenses = em.createQuery(query).getResultList();
            UserLicense userLicense = licenses.stream().filter(lic -> new LicenseKey(lic.getLicenseKey()).equals(licenseKey)).findAny().orElse(null);
            if (userLicense == null && licenses.size() >= this.config.getNumOfDevicesPerUser()) {
                Problem problem = Problem.valueOf((int)403, (URI)EXCEED_LICENSING_DEVICES);
                context.setMessage((Object)problem);
            } else {
                if (userLicense != null) {
                    LicenseLastActivity lastActivity = this.findLastActivity(em, userLicense);
                    EntityTransactionManager tx = new EntityTransactionManager(em);
                    if (lastActivity == null) {
                        tx.required(() -> em.persist(BeanBuilder.builder((Object)new LicenseLastActivity()).set(LicenseLastActivity::setUserLicense, (Object)userLicense).set(LicenseLastActivity::setUserAgent, (Object)Optional.ofNullable(context.getRequest().getHeaders()).map(headers -> headers.get((Object)"User-Agent")).map(ua -> ua.substring(0, Math.min(ua.length() - 1, 255))).orElse(null)).set(LicenseLastActivity::setLastUsedAt, (Object)LocalDateTime.now()).build()));
                    } else {
                        tx.required(() -> {
                            lastActivity.setUserAgent(Optional.ofNullable(context.getRequest().getHeaders()).map(headers -> headers.get((Object)"User-Agent")).map(ua -> ua.substring(0, Math.min(ua.length() - 1, 255))).orElse(null));
                            lastActivity.setLastUsedAt(LocalDateTime.now());
                        });
                    }
                    context.putValue((Object)userLicense);
                }
                context.putValue((Object)licenseKey);
            }
        });
    }
}

