/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.persondir;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.unicon.cas.addons.support.ResourceChangeDetectingEventNotifier;
import org.jasig.services.persondir.support.ComplexStubPersonAttributeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;

public class JsonBackedComplexStubPersonAttributeDao
extends ComplexStubPersonAttributeDao
implements ApplicationListener<ResourceChangeDetectingEventNotifier.ResourceChangedEvent> {
    private final Resource personAttributesConfigFile;
    private final ObjectMapper jacksonObjectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(JsonBackedComplexStubPersonAttributeDao.class);
    private final Object synchronizationMonitor = new Object();

    public JsonBackedComplexStubPersonAttributeDao(Resource personAttributesConfigFile) {
        this.personAttributesConfigFile = personAttributesConfigFile;
    }

    public void init() throws Exception {
        try {
            this.unmarshalAndSetBackingMap();
        }
        catch (ClassCastException ex) {
            throw new BeanCreationException(String.format("The semantic structure of the person attributes JSON config is not correct. Please fix it in this resource: [%s]", this.personAttributesConfigFile.getURI()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ResourceChangeDetectingEventNotifier.ResourceChangedEvent resourceChangedEvent) {
        Map savedBackingMap;
        try {
            if (!resourceChangedEvent.getResourceUri().equals(this.personAttributesConfigFile.getURI())) {
                return;
            }
        }
        catch (Throwable e) {
            logger.error("An exception is caught while trying to access JSON resource: ", e);
            return;
        }
        Object object = this.synchronizationMonitor;
        synchronized (object) {
            savedBackingMap = super.getBackingMap();
        }
        try {
            this.unmarshalAndSetBackingMap();
        }
        catch (Throwable ex) {
            logger.error("An exception is caught during reloading of the JSON configuration:", ex);
            Object object2 = this.synchronizationMonitor;
            synchronized (object2) {
                super.setBackingMap(savedBackingMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarshalAndSetBackingMap() throws Exception {
        logger.info("Un-marshaling person attributes from the config file [{}] ...", (Object)this.personAttributesConfigFile.getFile());
        Map backingMap = (Map)this.jacksonObjectMapper.readValue(this.personAttributesConfigFile.getFile(), Map.class);
        logger.debug("Person attributes have been successfully read into a Map<String, Map<String, List<Object>>>: {}", (Object)backingMap);
        Object object = this.synchronizationMonitor;
        synchronized (object) {
            super.setBackingMap(backingMap);
        }
    }
}

