/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.persondir;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.BasePersonAttributeDao;
import org.jasig.services.persondir.support.CaseInsensitiveNamedPersonImpl;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class GroovyPersonAttributeDao
extends BasePersonAttributeDao {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Resource groovyScriptResource;
    private String groovyScriptExecutingMethodName = "run";
    private boolean caseInsensitiveUsername = false;

    public GroovyPersonAttributeDao(Resource groovyScriptPath) throws IOException {
        this.verifyGroovyScriptAndThrowExceptionIfNeeded(groovyScriptPath);
        this.groovyScriptResource = groovyScriptPath;
    }

    public void setGroovyScriptExecutingMethodName(String methodName) {
        this.groovyScriptExecutingMethodName = methodName;
    }

    public void setCaseInsensitiveUsername(boolean caseInsensitiveUsername) {
        this.caseInsensitiveUsername = caseInsensitiveUsername;
    }

    private void verifyGroovyScriptAndThrowExceptionIfNeeded(Resource groovyScriptPath) throws IOException {
        if (!groovyScriptPath.exists()) {
            throw new RuntimeException("Groovy script cannot be found at the specifiied location: " + groovyScriptPath.getFilename());
        }
        if (groovyScriptPath.isOpen()) {
            throw new RuntimeException("Another process/application is busy with the specified groovy script");
        }
        if (!groovyScriptPath.isReadable()) {
            throw new RuntimeException("Groovy script cannot be read");
        }
        if (groovyScriptPath.contentLength() <= 0L) {
            throw new RuntimeException("Groovy script is empty and has no content");
        }
    }

    public IPersonAttributes getPerson(String uid) {
        try {
            ClassLoader parent = ((Object)((Object)this)).getClass().getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(this.groovyScriptResource.getFile());
            this.logger.debug("Loaded groovy class {} from script {}", (Object)groovyClass.getSimpleName(), (Object)this.groovyScriptResource.getFilename());
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            this.logger.debug("Created groovy object instance from class {}", (Object)this.groovyScriptResource.getFilename());
            Object[] args = new Object[]{uid, this.logger};
            this.logger.debug("Executing groovy script's {} method, with parameters {}", (Object)this.groovyScriptExecutingMethodName, (Object)args);
            Map personAttributesMap = (Map)groovyObject.invokeMethod(this.groovyScriptExecutingMethodName, (Object)args);
            this.logger.debug("Creating person attributes with the username {} and attributes {}", (Object)uid, (Object)personAttributesMap);
            Map<String, List<Object>> personAttributes = this.stuffAttributesIntoListValues(personAttributesMap);
            if (this.caseInsensitiveUsername) {
                return new CaseInsensitiveNamedPersonImpl(uid, personAttributes);
            }
            return new NamedPersonImpl(uid, personAttributes);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Map<String, List<Object>> stuffAttributesIntoListValues(Map<String, Object> personAttributesMap) {
        HashMap<String, List<Object>> personAttributes = new HashMap<String, List<Object>>();
        for (String key : personAttributesMap.keySet()) {
            Object value = personAttributesMap.get(key);
            if (value instanceof List) {
                personAttributes.put(key, (List)value);
                continue;
            }
            personAttributes.put(key, Arrays.asList(value));
        }
        return personAttributes;
    }

    public Set<IPersonAttributes> getPeople(Map<String, Object> query) {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query) {
        return null;
    }

    public Set<String> getPossibleUserAttributeNames() {
        throw new UnsupportedOperationException("This method is not implemented.");
    }

    public Set<String> getAvailableQueryAttributes() {
        throw new UnsupportedOperationException("This method is not implemented.");
    }
}

