/*
 * Decompiled with CFR 0.152.
 */
package net.unicon.cas.addon.serviceregistry.yaml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import net.unicon.cas.addon.serviceregistry.externalconfig.AbstractExternalConfigLoadingServiceRegistry;
import net.xrrocha.yamltag.DefaultYamlFactory;
import org.jasig.cas.services.RegisteredService;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlServiceRegistry
extends AbstractExternalConfigLoadingServiceRegistry {
    private final Yaml yaml = new DefaultYamlFactory().newYaml();

    protected List<RegisteredService> doUnmarshal(Resource externalServicesDefinitionSource) throws IOException {
        try {
            InputStream is = externalServicesDefinitionSource.getInputStream();
            Map records = (Map)this.yaml.loadAs(is, Map.class);
            if (records == null) {
                throw new IllegalStateException("YAML definition source is empty. Make sure to have a well-formed YAML file for registered services.");
            }
            List services = (List)records.get("services");
            if (services == null) {
                throw new IllegalStateException("YAML definition source is empty or missing top-level 'services' key. Make sure to have a well-formed YAML file for registered services.");
            }
            for (RegisteredService svc : services) {
                logger.info("Unmarshalled {}: {}", (Object)svc.getClass().getSimpleName(), (Object)svc);
            }
            return services;
        }
        catch (FileNotFoundException e) {
            logger.warn("Resource [{}] does not exist.", (Object)externalServicesDefinitionSource);
        }
        catch (YAMLException e) {
            throw new IllegalStateException("YAML definition source is malformed. Make sure to have a well-formed YAML file for registered services.", e);
        }
        return null;
    }
}

