/*******************************************************************************
 *
 * Copyright 2014-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package net.turnbig.jdbcx.dialect.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;

import net.turnbig.jdbcx.dialect.SQLDialect;
import net.turnbig.jdbcx.dialect.SelectSqlUtils;

/**
 * 
 * @author Woo Cupid
 * @date 2016年1月28日
 * @version $Revision$
 */
public abstract class AbstractSQLDialect implements SQLDialect {

	static final Logger logger = LoggerFactory.getLogger(AbstractSQLDialect.class);

	@Override
	public String getCountSql(final String sql) {
		return SelectSqlUtils.getCountSql(sql);
	}

	public String getPageableSqlWithLimitOffset(String sql, Pageable pageable) {
		String pagedSql = SelectSqlUtils.getPageableSqlWithLimitOffset(sql, pageable);
		logger.debug("original sql is : {}, paged sql is: {}", sql, pagedSql);
		return pagedSql;
	}

}
