/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.source;

import java.sql.Connection;
import java.sql.SQLException;
import net.truej.sql.fetch.Q;
import net.truej.sql.source.DataSourceW;
import net.truej.sql.source.Source;

public non-sealed class ConnectionW
implements Source,
Q<DataSourceW.Single, DataSourceW.Batched> {
    public final Connection w;

    public ConnectionW(Connection w) {
        this.w = w;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final <T, E extends Exception> T inTransaction(InTransactionAction<T, E> action) throws E {
        try {
            boolean oldAutoCommit = this.w.getAutoCommit();
            try {
                this.w.setAutoCommit(false);
                T result = action.run();
                this.w.commit();
                T t = result;
                return t;
            }
            catch (Throwable e) {
                this.w.rollback();
                throw e;
            }
            finally {
                this.w.setAutoCommit(oldAutoCommit);
            }
        }
        catch (SQLException e) {
            throw this.mapException(e);
        }
    }

    public static interface InTransactionAction<T, E extends Exception> {
        public T run() throws E;
    }
}

