/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.fetch;

import net.truej.sql.fetch.Constraint;
import org.jetbrains.annotations.Nullable;

public class ConstraintViolationException
extends RuntimeException {
    @Nullable
    private final String catalogName;
    @Nullable
    private final String schemaName;
    @Nullable
    private final String tableName;
    @Nullable
    private final String constraintName;

    public ConstraintViolationException(@Nullable String catalogName, @Nullable String schemaName, @Nullable String tableName, @Nullable String constraintName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.constraintName = constraintName;
    }

    @SafeVarargs
    public final <T, E extends Exception> T when(Constraint<T, E> ... constraints) throws E {
        for (Constraint<T, E> constraint : constraints) {
            if (this.catalogName != null && constraint.catalogName != null && !constraint.catalogName.equalsIgnoreCase(this.catalogName) || this.schemaName != null && constraint.schemaName != null && !constraint.schemaName.equalsIgnoreCase(this.schemaName) || this.tableName != null && !constraint.tableName.equalsIgnoreCase(this.tableName) || this.constraintName != null && !constraint.constraintName.equalsIgnoreCase(this.constraintName)) continue;
            return constraint.handler.handle();
        }
        throw this;
    }

    @Override
    public String toString() {
        return "ConstraintViolationException{catalogName='" + this.catalogName + "', schemaName='" + this.schemaName + "', tableName='" + this.tableName + "', constraintName='" + this.constraintName + "'}";
    }
}

