/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.function.Predicate;
import net.truej.sql.compiler.TrueSqlPlugin;
import org.jetbrains.annotations.Nullable;

public class TypeFinder {
    static RuntimeException badFormat(JCTree tree) {
        return new TrueSqlPlugin.ValidationException(tree, "Type not found (expected Name.class or full.qualified.Name.class or array[].class)");
    }

    static Type mapArrayOrScalarType(Symtab symtab, JCTree.JCCompilationUnit cu, JCTree.JCExpression tree) {
        if (tree instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree at = (JCTree.JCArrayTypeTree)tree;
            return new Type.ArrayType(TypeFinder.mapArrayOrScalarType(symtab, cu, at.elemtype), symtab.arrayClass);
        }
        Type found = TypeFinder.find(symtab, cu, tree);
        if (found == null) {
            throw TypeFinder.badFormat(tree);
        }
        return found;
    }

    public static Type resolve(Names names, Symtab symtab, JCTree.JCCompilationUnit cu, JCTree.JCExpression tree) {
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)tree;
            if (!fa.name.equals(names.fromString("class"))) {
                throw TypeFinder.badFormat(fa);
            }
            return TypeFinder.mapArrayOrScalarType(symtab, cu, fa.selected);
        }
        throw TypeFinder.badFormat(tree);
    }

    static Type ensureCompilationUnitCodeIsNotBroken(Symbol.ClassSymbol found) {
        if (found == null) {
            return null;
        }
        return new Type.ClassType(Type.noType, List.nil(), found);
    }

    @Nullable
    public static Type find(Symtab symtab, JCTree.JCCompilationUnit cu, JCTree.JCExpression tree) {
        Predicate<Symbol> isClass = s -> s instanceof Symbol.ClassSymbol;
        if (tree instanceof JCTree.JCPrimitiveTypeTree) {
            JCTree.JCPrimitiveTypeTree primitive = (JCTree.JCPrimitiveTypeTree)tree;
            TypeTag typeTag = primitive.typetag;
            return new Type.JCPrimitiveType(typeTag, switch (primitive.typetag) {
                case TypeTag.BYTE -> symtab.byteType.tsym;
                case TypeTag.CHAR -> symtab.charType.tsym;
                case TypeTag.SHORT -> symtab.shortType.tsym;
                case TypeTag.LONG -> symtab.longType.tsym;
                case TypeTag.FLOAT -> symtab.floatType.tsym;
                case TypeTag.INT -> symtab.intType.tsym;
                case TypeTag.DOUBLE -> symtab.doubleType.tsym;
                default -> symtab.booleanType.tsym;
            });
        }
        if (tree instanceof JCTree.JCIdent) {
            final JCTree.JCIdent id = (JCTree.JCIdent)tree;
            final Symbol.ClassSymbol[] found = new Symbol.ClassSymbol[]{null};
            found[0] = (Symbol.ClassSymbol)cu.toplevelScope.findFirst(id.name, isClass);
            if (found[0] == null) {
                cu.accept(new TreeScanner(){

                    @Override
                    public void visitClassDef(JCTree.JCClassDecl tree) {
                        if (tree.name.equals(id.name)) {
                            found[0] = tree.sym;
                        }
                        super.visitClassDef(tree);
                    }
                });
            }
            if (found[0] == null) {
                found[0] = (Symbol.ClassSymbol)cu.namedImportScope.findFirst(id.name, isClass);
            }
            if (found[0] == null) {
                found[0] = symtab.getClass(cu.modle, cu.packge.fullname.append('.', id.name));
            }
            if (found[0] == null) {
                found[0] = (Symbol.ClassSymbol)cu.starImportScope.findFirst(id.name, isClass);
            }
            return TypeFinder.ensureCompilationUnitCodeIsNotBroken(found[0]);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCExpression jCExpression;
            JCTree.JCFieldAccess tail = (JCTree.JCFieldAccess)tree;
            Name fqn = tail.name;
            while (true) {
                if ((jCExpression = tail.selected) instanceof JCTree.JCIdent) break;
                JCTree.JCFieldAccess tfa = (JCTree.JCFieldAccess)tail.selected;
                fqn = tfa.name.append('.', fqn);
                tail = tfa;
            }
            JCTree.JCIdent id = (JCTree.JCIdent)jCExpression;
            fqn = id.name.append('.', fqn);
            Symbol.ClassSymbol found = symtab.getClass(cu.modle, fqn);
            if (found == null) {
                found = symtab.getClass(symtab.java_base, fqn);
            }
            if (found == null) {
                return null;
            }
            return new Type.ClassType(Type.noType, List.nil(), found);
        }
        return null;
    }
}

