/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.tree.JCTree;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import net.truej.sql.bindings.Standard;
import net.truej.sql.compiler.ConfigurationParser;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.TrueSqlPlugin;

class TypeChecker {
    TypeChecker() {
    }

    static Standard.Binding getBindingForClass(JCTree tree, List<Standard.Binding> typeBindings, boolean isFullQualified, String javaClassName) {
        return typeBindings.stream().filter(b -> isFullQualified && b.className().equals(javaClassName) || !isFullQualified && b.className().endsWith(javaClassName)).findFirst().orElseThrow(() -> new TrueSqlPlugin.ValidationException(tree, "has no binding for type " + javaClassName));
    }

    static void assertTypesCompatible(String onDatabase, int sqlType, String sqlTypeName, String sqlJavaClassName, int sqlScale, Standard.Binding javaBinding, TypeMismatchHandler handler) {
        if ((onDatabase.equals("MySQL") || onDatabase.equals("MariaDB")) && sqlType == -5 && (javaBinding.className().equals(Long.class.getName()) || javaBinding.className().equals(Long.TYPE.getName()))) {
            return;
        }
        if (onDatabase.equals("Oracle")) {
            if (sqlTypeName.equals("DATE") && javaBinding.className().equals(LocalDate.class.getName())) {
                return;
            }
            if (sqlTypeName.equals("UNSPECIFIED")) {
                return;
            }
            if (sqlTypeName.equals("NUMBER") && (sqlScale == 0 || sqlScale == -127) && (javaBinding.className().equals(Long.class.getName()) || javaBinding.className().equals(Long.TYPE.getName()) || javaBinding.className().equals(Integer.class.getName()) || javaBinding.className().equals(Integer.TYPE.getName()) || javaBinding.className().equals(Short.class.getName()) || javaBinding.className().equals(Short.TYPE.getName()) || javaBinding.className().equals(Byte.class.getName()) || javaBinding.className().equals(Byte.TYPE.getName()))) {
                return;
            }
        }
        if (onDatabase.equals("PostgreSQL")) {
            if (javaBinding.className().equals(OffsetDateTime.class.getName()) && sqlTypeName.equals("timestamptz")) {
                return;
            }
            if (javaBinding.className().equals(OffsetTime.class.getName()) && sqlTypeName.equals("timetz")) {
                return;
            }
        }
        if (onDatabase.equals("Microsoft SQL Server") && javaBinding.className().equals(OffsetDateTime.class.getName()) && sqlJavaClassName.equals("microsoft.sql.DateTimeOffset")) {
            return;
        }
        if (onDatabase.equals("Oracle") && javaBinding.className().equals(ZonedDateTime.class.getName()) && sqlJavaClassName.equals("oracle.sql.TIMESTAMPTZ")) {
            return;
        }
        if ((javaBinding.className().equals(Integer.TYPE.getName()) || javaBinding.className().equals(Integer.class.getName())) && (sqlJavaClassName.equals(Integer.TYPE.getName()) || sqlJavaClassName.equals(Integer.class.getName()))) {
            if (sqlType == -6) {
                throw handler.onError("type", javaBinding.className(), "java.lang.Byte");
            }
            if (sqlType == 5) {
                throw handler.onError("type", javaBinding.className(), "java.lang.Short");
            }
        }
        if ((javaBinding.className().equals(Boolean.TYPE.getName()) || javaBinding.className().equals(Boolean.class.getName())) && (sqlJavaClassName.equals(Boolean.TYPE.getName()) || sqlJavaClassName.equals(Boolean.class.getName())) || (javaBinding.className().equals(Byte.TYPE.getName()) || javaBinding.className().equals(Byte.class.getName())) && (sqlJavaClassName.equals(Byte.TYPE.getName()) || sqlJavaClassName.equals(Byte.class.getName()) || sqlType == -6) || (javaBinding.className().equals(Short.TYPE.getName()) || javaBinding.className().equals(Short.class.getName())) && (sqlJavaClassName.equals(Short.TYPE.getName()) || sqlJavaClassName.equals(Short.class.getName()) || sqlType == 5) || (javaBinding.className().equals(Integer.TYPE.getName()) || javaBinding.className().equals(Integer.class.getName())) && (sqlJavaClassName.equals(Integer.TYPE.getName()) || sqlJavaClassName.equals(Integer.class.getName())) || (javaBinding.className().equals(Long.TYPE.getName()) || javaBinding.className().equals(Long.class.getName())) && (sqlJavaClassName.equals(Long.TYPE.getName()) || sqlJavaClassName.equals(Long.class.getName())) || (javaBinding.className().equals(Float.TYPE.getName()) || javaBinding.className().equals(Float.class.getName())) && (sqlJavaClassName.equals(Float.TYPE.getName()) || sqlJavaClassName.equals(Float.class.getName())) || (javaBinding.className().equals(Double.TYPE.getName()) || javaBinding.className().equals(Double.class.getName())) && (sqlJavaClassName.equals(Double.TYPE.getName()) || sqlJavaClassName.equals(Double.class.getName()))) {
            return;
        }
        if (javaBinding.compatibleSqlType() == null && javaBinding.compatibleSqlTypeName() == null) {
            if (!javaBinding.className().equals(sqlJavaClassName)) {
                throw handler.onError("type", javaBinding.className(), sqlJavaClassName);
            }
        } else {
            if (javaBinding.compatibleSqlTypeName() != null && !javaBinding.compatibleSqlTypeName().equalsIgnoreCase(sqlTypeName)) {
                throw handler.onError("sql type name", javaBinding.compatibleSqlTypeName(), sqlTypeName);
            }
            if (javaBinding.compatibleSqlType() != null && javaBinding.compatibleSqlType() != sqlType) {
                throw handler.onError("sql type id (java.sql.Types)", "" + javaBinding.compatibleSqlType(), "" + sqlType);
            }
        }
    }

    static void assertNullabilityCompatible(GLangParser.NullMode sqlNullMode, GLangParser.NullMode javaNullMode, NullabilityMismatchHandler handler) {
        static enum Decision {
            OK,
            WARN,
            ERROR;

        }
        Decision decision = Decision.OK;
        block0 : switch (javaNullMode) {
            case EXACTLY_NULLABLE: {
                switch (sqlNullMode) {
                    case EXACTLY_NULLABLE: 
                    case DEFAULT_NOT_NULL: {
                        break;
                    }
                    case EXACTLY_NOT_NULL: {
                        decision = Decision.WARN;
                    }
                }
                break;
            }
            case DEFAULT_NOT_NULL: {
                switch (sqlNullMode) {
                    case EXACTLY_NULLABLE: {
                        decision = Decision.ERROR;
                        break block0;
                    }
                }
                break;
            }
            case EXACTLY_NOT_NULL: {
                switch (sqlNullMode) {
                    case EXACTLY_NULLABLE: {
                        decision = Decision.WARN;
                        break block0;
                    }
                }
            }
        }
        if (decision != Decision.OK) {
            handler.onMismatch(decision == Decision.WARN, sqlNullMode, javaNullMode);
        }
    }

    static String inferType(ConfigurationParser.ParsedConfiguration parsedConfig, String onDatabase, GLangParser.ColumnMetadata column, GLangParser.NullMode nullMode) {
        if (nullMode == GLangParser.NullMode.DEFAULT_NOT_NULL || nullMode == GLangParser.NullMode.EXACTLY_NOT_NULL) {
            if (column.javaClassName().equals(Boolean.class.getName()) || column.sqlType() == 16) {
                return Boolean.TYPE.getName();
            }
            if (column.javaClassName().equals(Byte.class.getName()) || column.sqlType() == -6) {
                return Byte.TYPE.getName();
            }
            if (column.javaClassName().equals(Short.class.getName()) || column.sqlType() == 5) {
                return Short.TYPE.getName();
            }
            if (column.javaClassName().equals(Integer.class.getName()) || column.sqlType() == 4) {
                return Integer.TYPE.getName();
            }
            if (column.javaClassName().equals(Long.class.getName()) || column.sqlType() == -5) {
                return Long.TYPE.getName();
            }
            if (column.javaClassName().equals(Float.class.getName()) || column.sqlType() == 6) {
                return Float.TYPE.getName();
            }
            if (column.javaClassName().equals(Double.class.getName()) || column.sqlType() == 8) {
                return Double.TYPE.getName();
            }
        }
        if (onDatabase.equals("Microsoft SQL Server") && column.javaClassName().equals("microsoft.sql.DateTimeOffset")) {
            return "java.time.OffsetDateTime";
        }
        if (onDatabase.equals("Oracle") && column.javaClassName().equals("oracle.sql.TIMESTAMPTZ")) {
            return "java.time.ZonedDateTime";
        }
        if (onDatabase.equals("PostgreSQL")) {
            if (column.sqlTypeName().equals("timetz")) {
                return "java.time.OffsetTime";
            }
            if (column.sqlTypeName().equals("timestamptz")) {
                return "java.time.OffsetDateTime";
            }
        }
        return switch (column.sqlType()) {
            case 91 -> "java.time.LocalDate";
            case 92 -> "java.time.LocalTime";
            case 93 -> "java.time.LocalDateTime";
            case 2014 -> "java.time.OffsetDateTime";
            default -> parsedConfig.typeBindings().stream().filter(b -> column.sqlTypeName().equals(b.compatibleSqlTypeName())).findFirst().map(Standard.Binding::className).orElse(column.javaClassName());
        };
    }

    static interface TypeMismatchHandler {
        public RuntimeException onError(String var1, String var2, String var3);
    }

    static interface NullabilityMismatchHandler {
        public void onMismatch(boolean var1, GLangParser.NullMode var2, GLangParser.NullMode var3);
    }
}

