/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import net.truej.sql.TrueSql;
import net.truej.sql.compiler.CompilerMessages;
import net.truej.sql.compiler.ConfigurationParser;
import net.truej.sql.compiler.InvocationsFinder;
import net.truej.sql.compiler.TrueSqlPlugin;
import net.truej.sql.config.Configuration;
import net.truej.sql.config.TypeReadWrite;
import net.truej.sql.fetch.EvenSoNullPointerException;
import net.truej.sql.fetch.Parameters;
import net.truej.sql.fetch.TooFewRowsException;
import net.truej.sql.fetch.TooMuchRowsException;
import net.truej.sql.fetch.UpdateResult;
import net.truej.sql.fetch.UpdateResultStream;
import net.truej.sql.source.ConnectionW;
import net.truej.sql.source.DataSourceW;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SupportedAnnotationTypes(value={"net.truej.sql.TrueSql", "net.truej.sql.config.Configuration"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_21)
public class TrueSqlAnnotationProcessor
extends AbstractProcessor {
    static final String GENERATED_CLASS_NAME_SUFFIX = "G";

    static void checkedExceptionAsUnchecked(Action<IOException> fn) {
        try {
            fn.run();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Pair<JCTree, JCTree.JCCompilationUnit> found;
        JavacProcessingEnvironment env = (JavacProcessingEnvironment)this.processingEnv;
        Context context = env.getContext();
        Symtab symtab = Symtab.instance(context);
        Names names = Names.instance(context);
        JavacElements elements = JavacElements.instance(context);
        Log javacLog = Log.instance(context);
        CompilerMessages messages = new CompilerMessages(context);
        if (annotations.isEmpty()) {
            return false;
        }
        if ("true".equals(ConfigurationParser.findProperty("truesql.printConfig"))) {
            javacLog.printRawLines("TrueSql configuration:");
            for (Element element : roundEnv.getElementsAnnotatedWith(Configuration.class)) {
                found = elements.getTreeAndTopLevel(element, null, null);
                ConfigurationParser.parseConfig(symtab, names, (JCTree.JCCompilationUnit)found.snd, (Symbol.ClassSymbol)element, (propName, propValue) -> javacLog.printRawLines("\t" + propName + (String)(propValue == null ? " UNDEFINED" : "=" + propValue)));
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(TrueSql.class)) {
            found = elements.getTreeAndTopLevel(element, null, null);
            JCTree tree = (JCTree)found.fst;
            JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)found.snd;
            Symbol.ClassSymbol elementSymbol = (Symbol.ClassSymbol)element;
            HashMap<JCTree.JCCompilationUnit, 1> cuInfo = context.get(HashMap.class);
            if (cuInfo == null) {
                cuInfo = new HashMap<JCTree.JCCompilationUnit, 1>();
                context.put(HashMap.class, cuInfo);
            }
            String generatedClassFqn = String.valueOf(elementSymbol.getQualifiedName()) + GENERATED_CLASS_NAME_SUFFIX;
            final LinkedHashMap<JCTree.JCMethodInvocation, TrueSqlPlugin.MethodInvocationResult> invocations = InvocationsFinder.find(symtab, names, messages, cu, tree, generatedClassFqn);
            cuInfo.put(cu, new LinkedHashMap<JCTree.JCMethodInvocation, Object>(){
                {
                    for (Map.Entry kv : invocations.entrySet()) {
                        this.put((JCTree.JCMethodInvocation)kv.getKey(), TrueSqlPlugin.doofyEncode(kv.getValue()));
                    }
                }
            });
            TrueSqlAnnotationProcessor.checkedExceptionAsUnchecked(() -> {
                try (PrintWriter out = new PrintWriter(env.getFiler().createSourceFile(generatedClassFqn, element).openWriter());){
                    out.write("package " + elementSymbol.getQualifiedName().toString().replace("." + elementSymbol.getSimpleName().toString(), "") + ";\n");
                    out.write("import " + TypeReadWrite.class.getName() + ";\n");
                    out.write("import " + ConnectionW.class.getName() + ";\n");
                    out.write("import " + DataSourceW.class.getName() + ";\n");
                    out.write("import " + TooMuchRowsException.class.getName() + ";\n");
                    out.write("import " + TooFewRowsException.class.getName() + ";\n");
                    out.write("import " + UpdateResult.class.getName() + ";\n");
                    out.write("import " + UpdateResultStream.class.getName() + ";\n");
                    out.write("import " + Function.class.getName() + ";\n");
                    out.write("import " + Parameters.class.getName() + ".*;\n");
                    out.write("import " + EvenSoNullPointerException.class.getName() + ";\n");
                    out.write("import " + Nullable.class.getName() + ";\n");
                    out.write("import " + NotNull.class.getName() + ";\n");
                    out.write("import net.truej.sql.bindings.*;\n");
                    out.write("import java.util.List;\n");
                    out.write("import java.util.stream.Stream;\n");
                    out.write("import java.util.stream.Collectors;\n");
                    out.write("import java.util.Objects;\n");
                    out.write("import java.sql.SQLException;\n");
                    out.write("class %s { \n".formatted(String.valueOf(elementSymbol.getSimpleName()) + GENERATED_CLASS_NAME_SUFFIX));
                    for (TrueSqlPlugin.MethodInvocationResult result : invocations.values()) {
                        if (!(result instanceof TrueSqlPlugin.FetchInvocation)) continue;
                        TrueSqlPlugin.FetchInvocation fi = (TrueSqlPlugin.FetchInvocation)result;
                        out.write(fi.generatedCode());
                    }
                    out.write("}");
                }
            });
        }
        return false;
    }

    static interface Action<E extends Exception> {
        public void run() throws E;
    }
}

