/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.tree.JCTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.truej.sql.compiler.DtoGenerator;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.InvocationsFinder;
import net.truej.sql.compiler.MapperGenerator;
import net.truej.sql.compiler.TrueSqlPlugin;
import org.jetbrains.annotations.Nullable;

public class StatementGenerator {
    public static int unfoldArgumentsCount(@Nullable JCTree.JCLambda extractor) {
        return extractor == null ? 1 : ((JCTree.JCNewArray)extractor.body).elems.size();
    }

    public static String generate(Function<String, String> typeToRwClass, int lineNumber, SourceMode source, Query query, StatementMode prepareAs, FetchMode fetchAs, boolean generateDto, boolean withUpdateCount) {
        WriteNext execute;
        WriteNext setParameters;
        WriteNext queryText;
        WriteNext parametersCode;
        WriteNext throwsClause;
        WriteNext typeParameters;
        Object __;
        Record __2;
        FetchTo to;
        GLangParser.FetchToField fetchToField;
        Out out = new Out(new StringBuilder());
        if (generateDto && fetchAs instanceof FetchTo && (fetchToField = (to = (FetchTo)fetchAs).toField()) instanceof GLangParser.ListOfGroupField) {
            GLangParser.ListOfGroupField agg = (GLangParser.ListOfGroupField)fetchToField;
            DtoGenerator.generate(out, agg);
            out.w("\n");
        }
        String updateCountType = query instanceof BatchedQuery ? "long[]" : "Long";
        BiFunction<String, String, String> wrapTypeWithUpdateCount = (collectionT, t) -> {
            String boxed = MapperGenerator.boxedClassName(t);
            if (fetchAs instanceof FetchNone) {
                return updateCountType;
            }
            Supplier<String> toCollectionType = () -> collectionT != null ? collectionT + "<" + boxed + ">" : boxed;
            if (!withUpdateCount) {
                return toCollectionType.get();
            }
            return fetchAs instanceof FetchStream ? "UpdateResultStream<" + updateCountType + ", " + boxed + ">" : "UpdateResult<" + updateCountType + ", " + toCollectionType.get() + ">";
        };
        FetchMode fetchMode = fetchAs;
        Objects.requireNonNull(fetchMode);
        FetchMode fetchMode2 = fetchMode;
        int n = 0;
        String methodName = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FetchNone.class, FetchList.class, FetchOne.class, FetchOneOrZero.class, FetchStream.class}, (Object)fetchMode2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                FetchNone __3 = (FetchNone)fetchMode2;
                yield "fetchNone";
            }
            case 1 -> {
                __2 = (FetchList)fetchMode2;
                yield "fetchList";
            }
            case 2 -> {
                FetchOne __ = (FetchOne)fetchMode2;
                yield "fetchOne";
            }
            case 3 -> {
                FetchOneOrZero __ = (FetchOneOrZero)fetchMode2;
                yield "fetchOneOrZero";
            }
            case 4 -> {
                __ = (FetchStream)fetchMode2;
                yield "fetchStream";
            }
        };
        FetchMode fetchMode3 = fetchAs;
        Objects.requireNonNull(fetchMode3);
        FetchMode fetchMode4 = fetchMode3;
        int __3 = 0;
        String resultType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FetchNone.class, FetchTo.class}, (Object)fetchMode4, __3)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                __2 = (FetchNone)fetchMode4;
                yield wrapTypeWithUpdateCount.apply(null, "Void");
            }
            case 1 -> {
                FetchTo to = (FetchTo)fetchMode4;
                GLangParser.FetchToField v4 = to.toField();
                Objects.requireNonNull(v4);
                __ = v4;
                int var19_22 = 0;
                String v5 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ScalarField.class, GLangParser.ListOfGroupField.class}, (Object)__, var19_22)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        GLangParser.ScalarField sf = (GLangParser.ScalarField)__;
                        yield TrueSqlPlugin.classNameToSourceCodeType(sf.binding().className());
                    }
                    case 1 -> {
                        GLangParser.ListOfGroupField lgf = (GLangParser.ListOfGroupField)__;
                        yield lgf.newJavaClassName();
                    }
                };
                String toSourceCodeType = v5;
                FetchTo v6 = to;
                Objects.requireNonNull(v6);
                FetchTo var19_23 = v6;
                int sf = 0;
                String v7 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FetchOne.class, FetchOneOrZero.class, FetchList.class, FetchStream.class}, (Object)var19_23, sf)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        FetchOne __4 = (FetchOne)var19_23;
                        yield null;
                    }
                    case 1 -> {
                        FetchOneOrZero __ = (FetchOneOrZero)var19_23;
                        yield null;
                    }
                    case 2 -> {
                        FetchList __ = (FetchList)var19_23;
                        yield "List";
                    }
                    case 3 -> {
                        FetchStream __ = (FetchStream)var19_23;
                        yield "Stream";
                    }
                };
                String wrapWith = v7;
                yield wrapTypeWithUpdateCount.apply(wrapWith, toSourceCodeType);
            }
        };
        Query query2 = query;
        Objects.requireNonNull(query2);
        Query sf = query2;
        int __4 = 0;
        String from = switch (source.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "DataSourceW source";
            case 1 -> "ConnectionW source";
        };
        WriteNext prepare = o -> {
            StatementMode statementMode = prepareAs;
            Objects.requireNonNull(statementMode);
            StatementMode selector0$temp = statementMode;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AsCall.class, AsDefault.class, AsGeneratedKeysColumnNames.class, AsGeneratedKeysIndices.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    AsCall __ = (AsCall)selector0$temp;
                    yield o.w("prepareCall(query)");
                }
                case 1 -> {
                    AsDefault __ = (AsDefault)selector0$temp;
                    yield o.w("prepareStatement(query)");
                }
                case 2 -> {
                    AsGeneratedKeysColumnNames gk = (AsGeneratedKeysColumnNames)selector0$temp;
                    String names = Arrays.stream(gk.columnNames).map(cn -> "\"" + cn + "\"").collect(Collectors.joining(", "));
                    yield o.w("prepareStatement(query, new String[] { ", names, " })");
                }
                case 3 -> {
                    AsGeneratedKeysIndices gk = (AsGeneratedKeysIndices)selector0$temp;
                    String indexes = Arrays.stream(gk.columnIndexes).mapToObj(String::valueOf).collect(Collectors.joining(", "));
                    yield o.w("prepareStatement(query, new int[] { ", indexes, " })");
                }
            };
        };
        WriteNext getResultSet = o -> {
            StatementMode statementMode = prepareAs;
            Objects.requireNonNull(statementMode);
            StatementMode selector0$temp = statementMode;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AsCall.class, AsDefault.class, AsGeneratedKeys.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    AsCall __ = (AsCall)selector0$temp;
                    yield null;
                }
                case 1 -> {
                    AsDefault __ = (AsDefault)selector0$temp;
                    yield o.w("var rs = stmt.getResultSet();");
                }
                case 2 -> {
                    AsGeneratedKeys __ = (AsGeneratedKeys)selector0$temp;
                    yield o.w("var rs = stmt.getGeneratedKeys();");
                }
            };
        };
        Function<String, String> wrapResultWithUpdateCount = result -> {
            String wrapper = fetchAs instanceof FetchStream ? "UpdateResultStream" : "UpdateResult";
            return withUpdateCount ? "new " + wrapper + "<>(" + updateCount + ", " + result + ")" : result;
        };
        WriteNext doFetch = o -> {
            FetchMode fetchMode = fetchAs;
            Objects.requireNonNull(fetchMode);
            FetchMode selector0$temp = fetchMode;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FetchNone.class, FetchTo.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    FetchNone __ = (FetchNone)selector0$temp;
                    if (withUpdateCount) {
                        yield o.w("return ", updateCount, ";");
                    }
                    yield o.w("return null;");
                }
                case 1 -> {
                    FetchTo to = (FetchTo)selector0$temp;
                    MapperGenerator.generate(o, to.toField(), prepareAs instanceof AsCall ? InvocationsFinder.getOutParametersNumbers(query) : null, typeToRwClass);
                    FetchTo v2 = to;
                    Objects.requireNonNull(v2);
                    FetchTo selector2$temp = v2;
                    int index$3 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FetchList.class, FetchOne.class, FetchOneOrZero.class, FetchStream.class}, (Object)selector2$temp, index$3)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            FetchList __ = (FetchList)selector2$temp;
                            yield o.w("return ", wrapResultWithUpdateCount.apply("mapped.toList()"), ";");
                        }
                        case 1: {
                            FetchOne __ = (FetchOne)selector2$temp;
                            if (prepareAs instanceof AsCall) {
                                yield o.w("return ", wrapResultWithUpdateCount.apply("mapped"), ";\n");
                            }
                            yield o.w("var iterator = mapped.iterator();\n", "if (iterator.hasNext()) {\n", "    var result = iterator.next();\n", "    if (iterator.hasNext())\n", "        throw new TooMuchRowsException();\n", "\n", "    return ", wrapResultWithUpdateCount.apply("result"), ";\n", "} else\n", "    throw new TooFewRowsException();\n");
                        }
                        case 2: {
                            FetchOneOrZero __ = (FetchOneOrZero)selector2$temp;
                            yield o.w("var iterator = mapped.iterator();\n", "if (iterator.hasNext()) {\n", "    var result = iterator.next();\n", "    if (iterator.hasNext())\n", "        throw new TooMuchRowsException();\n", "    return ", wrapResultWithUpdateCount.apply("result"), ";\n", "}\n", "\n", "return ", wrapResultWithUpdateCount.apply("null"), ";");
                        }
                        case 3: 
                    }
                    FetchStream __ = (FetchStream)selector2$temp;
                    WriteNext closeRoutine = oo -> source == SourceMode.DATASOURCE ? oo.w("try {\n    stmt.close();\n} finally {\n", "    connection.close();\n", "}") : oo.w("stmt.close();");
                    yield o.w("var closable = mapped.onClose(() -> {\n", "    try {\n", "    ", closeRoutine, "\n", "     } catch(SQLException e) {\n         throw source.mapException(e);\n", "     }\n", "});\n", "return ", wrapResultWithUpdateCount.apply("closable"), ";");
                }
            };
        };
        WriteNext doWithPrepared = o -> o.w(setParameters, "\n", "\n", execute, "\n", "\n", getResultSet, "\n", "\n", doFetch);
        WriteNext acquireStatement = o -> fetchAs instanceof FetchStream ? o.w("var stmt = connection.", prepare, ";\n", "try {\n", "\n", "    ", doWithPrepared, "\n", "\n", "} catch (Exception e) {\n", "    try {\n", "        stmt.close();\n", "    } catch (Exception e2) {\n", "        e.addSuppressed(e2);\n", "    }\n", "    throw e;\n", "}") : o.w("try (var stmt = connection.", prepare, ") {\n", "\n", "    ", doWithPrepared, "\n", "}");
        WriteNext handleSqlException = o -> o.w("} catch (SQLException e) {\n", "    throw source.mapException(e);\n", "}");
        WriteNext doWithSource = o -> switch (source.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (fetchAs instanceof FetchStream) {
                    yield o.w("try {\n", "    var connection = source.w.getConnection();\n", "    ", acquireStatement, "\n", handleSqlException);
                }
                yield o.w("try (var connection = source.w.getConnection()) {\n", "    ", acquireStatement, "\n", handleSqlException);
            }
            case 1 -> o.w("try {\n", "    var connection = source.w;\n", "    ", acquireStatement, "\n", handleSqlException);
        };
        out.w("public static ", typeParameters, "\n", resultType, " ", methodName, "__line", lineNumber, "__(\n", "    ", parametersCode, "\n", "    ", from, "\n", ") ", throwsClause, " {\n", "    ", queryText, ";\n", "    ", doWithSource, "\n", "}\n");
        return out.buffer.toString();
    }

    private static /* synthetic */ Void lambda$generate$31(Out o) {
        return o.w("stmt.execute();");
    }

    private static /* synthetic */ Void lambda$generate$30(List parameterParts, Out o) {
        WriteNext setters = Out.each(parameterParts, "\n", (oo, i, p) -> {
            InvocationsFinder.ParameterPart parameterPart = p;
            Objects.requireNonNull(parameterPart);
            InvocationsFinder.ParameterPart selector0$temp = parameterPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InvocationsFinder.InParameter.class, InvocationsFinder.InoutParameter.class, InvocationsFinder.OutParameter.class, InvocationsFinder.UnfoldParameter.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    InvocationsFinder.InParameter __ = (InvocationsFinder.InParameter)selector0$temp;
                    yield oo.w("prw", i + 1, ".set(stmt, ++n, p", i + 1, ");");
                }
                case 1 -> {
                    InvocationsFinder.InoutParameter __ = (InvocationsFinder.InoutParameter)selector0$temp;
                    yield oo.w("prw", i + 1, ".set(stmt, ++n, p", i + 1, ");\n", "prw", i + 1, ".registerOutParameter(stmt, n);");
                }
                case 2 -> {
                    InvocationsFinder.OutParameter __ = (InvocationsFinder.OutParameter)selector0$temp;
                    yield oo.w("prw", i + 1, ".registerOutParameter(stmt, ++n);");
                }
                case 3 -> {
                    InvocationsFinder.UnfoldParameter up = (InvocationsFinder.UnfoldParameter)selector0$temp;
                    int n = StatementGenerator.unfoldArgumentsCount(up.extractor());
                    WriteNext unfolded = Out.each(IntStream.range(0, n).boxed().toList(), "\n", (ooo, j, __) -> ooo.w("prw", i + 1, "e", j + 1, ".set(stmt, ++n, ", up.extractor() == null ? "element" : "p" + (i + 1) + "e" + (j + 1) + ".apply(element)", ");"));
                    yield oo.w("\n", "for (var element : p", i + 1, ") {\n", "    ", unfolded, "\n", "}");
                }
            };
        });
        return o.w("var n = 0;\n", setters);
    }

    private static /* synthetic */ Void lambda$generate$27(SingleQuery sp, Out o) {
        int[] pIndex = new int[]{1};
        WriteNext generator = Out.each(sp.parts, "\n", (oo, __, p) -> {
            InvocationsFinder.QueryPart queryPart = p;
            Objects.requireNonNull(queryPart);
            InvocationsFinder.QueryPart selector0$temp = queryPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InvocationsFinder.TextPart.class, InvocationsFinder.SingleParameter.class, InvocationsFinder.UnfoldParameter.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    InvocationsFinder.TextPart t = (InvocationsFinder.TextPart)selector0$temp;
                    yield oo.w("buffer.append(\"\"\"\n", t.text(), "\"\"\");");
                }
                case 1 -> {
                    InvocationsFinder.SingleParameter ___ = (InvocationsFinder.SingleParameter)selector0$temp;
                    pIndex[0] = pIndex[0] + 1;
                    yield oo.w("buffer.append(\" ? \");");
                }
                case 2 -> {
                    InvocationsFinder.UnfoldParameter up = (InvocationsFinder.UnfoldParameter)selector0$temp;
                    int n = StatementGenerator.unfoldArgumentsCount(up.extractor());
                    WriteNext unfolded = Out.each(IntStream.range(0, n).boxed().toList(), ", ", (ooo, ___, ____) -> ooo.w("?"));
                    Object[] v2 = new Object[11];
                    v2[0] = "for (var i = 0; i < p";
                    v2[1] = pIndex[0];
                    v2[2] = ".size(); i++) {\n";
                    v2[3] = "    buffer.append(\" (";
                    v2[4] = unfolded;
                    v2[5] = ") \");\n";
                    v2[6] = "    if (i != p";
                    int v3 = pIndex[0];
                    pIndex[0] = v3 + 1;
                    v2[7] = v3;
                    v2[8] = ".size() - 1)\n";
                    v2[9] = "        buffer.append(\", \");\n";
                    v2[10] = "}";
                    yield oo.w(v2);
                }
            };
        });
        return o.w("var buffer = new StringBuilder();\n\n", generator, "\n\n", "var query = buffer.toString()");
    }

    private static /* synthetic */ Void lambda$generate$24(Out o) {
        return null;
    }

    private static /* synthetic */ Void lambda$generate$23(WriteNext eachParameter, Out o) {
        return o.w(eachParameter, ",");
    }

    private static /* synthetic */ Void lambda$generate$22(Out o) {
        return o.w("");
    }

    private static /* synthetic */ Void lambda$generate$21(Out o, Integer i, InvocationsFinder.ParameterPart p) {
        InvocationsFinder.ParameterPart parameterPart = p;
        Objects.requireNonNull(parameterPart);
        InvocationsFinder.ParameterPart selector0$temp = parameterPart;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InvocationsFinder.InOrInoutParameter.class, InvocationsFinder.OutParameter.class, InvocationsFinder.UnfoldParameter.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                InvocationsFinder.InOrInoutParameter __ = (InvocationsFinder.InOrInoutParameter)selector0$temp;
                yield o.w("P", i + 1, " p", i + 1, " ,\n", "TypeReadWrite<P", i + 1, "> prw", i + 1);
            }
            case 1 -> {
                InvocationsFinder.OutParameter __ = (InvocationsFinder.OutParameter)selector0$temp;
                yield o.w("TypeReadWrite<P", i + 1, "> prw", i + 1);
            }
            case 2 -> {
                InvocationsFinder.UnfoldParameter up = (InvocationsFinder.UnfoldParameter)selector0$temp;
                int n = StatementGenerator.unfoldArgumentsCount(up.extractor());
                if (up.extractor() == null) {
                    yield o.w("List<P", i + 1, "> p", i + 1, ",\n", "TypeReadWrite<P", i + 1, "> prw", i + 1, "e1");
                }
                WriteNext extractorsAndRw = Out.each(IntStream.range(0, n).boxed().toList(), ",\n", (oo, j, __) -> oo.w("Function<P", i + 1, ", P", i + 1, "E", j + 1, "> p", i + 1, "e", j + 1, ",\n", "TypeReadWrite<P", i + 1, "E", j + 1, "> prw", i + 1, "e", j + 1));
                yield o.w("List<P", i + 1, "> p", i + 1, ",\n", extractorsAndRw);
            }
        };
    }

    private static /* synthetic */ Void lambda$generate$19(WriteNext eachTypeParameter, Out o) {
        return o.w("<", eachTypeParameter, ">");
    }

    private static /* synthetic */ Void lambda$generate$18(Out o) {
        return o.w("");
    }

    private static /* synthetic */ Void lambda$generate$17(Out o, Integer i, InvocationsFinder.ParameterPart p) {
        InvocationsFinder.ParameterPart parameterPart = p;
        Objects.requireNonNull(parameterPart);
        InvocationsFinder.ParameterPart selector0$temp = parameterPart;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InvocationsFinder.SingleParameter.class, InvocationsFinder.UnfoldParameter.class}, (Object)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                InvocationsFinder.SingleParameter __ = (InvocationsFinder.SingleParameter)selector0$temp;
                yield o.w("P", i + 1);
            }
            case 1 -> {
                InvocationsFinder.UnfoldParameter up = (InvocationsFinder.UnfoldParameter)selector0$temp;
                int n = StatementGenerator.unfoldArgumentsCount(up.extractor());
                if (up.extractor() == null) {
                    yield o.w("P", i + 1);
                }
                WriteNext elements = Out.each(IntStream.range(0, n).boxed().toList(), ", ", (oo, j, __) -> oo.w("P", i + 1, "E", j + 1));
                yield o.w("P", i + 1, ", ", elements);
            }
        };
    }

    private static /* synthetic */ InvocationsFinder.ParameterPart lambda$generate$15(InvocationsFinder.QueryPart p) {
        return (InvocationsFinder.ParameterPart)p;
    }

    private static /* synthetic */ boolean lambda$generate$14(InvocationsFinder.QueryPart p) {
        return p instanceof InvocationsFinder.ParameterPart;
    }

    private static /* synthetic */ Void lambda$generate$13(Out o) {
        return o.w("var updateCount = stmt.executeLargeBatch();");
    }

    private static /* synthetic */ Void lambda$generate$12(WriteNext eachSetParameter, Out o) {
        return o.w("for (var element : batch) {\n", "    ", eachSetParameter, "\n", "    stmt.addBatch();\n", "}");
    }

    private static /* synthetic */ Void lambda$generate$11(Out o, Integer i, InvocationsFinder.QueryPart __) {
        return o.w("var p", i + 1, " = pe", i + 1, ".apply(element);\n", "prw", i + 1, ".set(stmt, ", i + 1, ", p", i + 1, ");\n");
    }

    private static /* synthetic */ Void lambda$generate$10(WriteNext queryAgg, Out o) {
        return o.w("var query = \"\"\"\n", queryAgg, "\"\"\"");
    }

    private static /* synthetic */ Void lambda$generate$9(Out o, Integer __, InvocationsFinder.QueryPart p) {
        Void void_;
        if (p instanceof InvocationsFinder.TextPart) {
            InvocationsFinder.TextPart tp = (InvocationsFinder.TextPart)p;
            void_ = o.w(tp.text());
        } else {
            void_ = o.w("?");
        }
        return void_;
    }

    private static /* synthetic */ Void lambda$generate$8(WriteNext eachParameterDecl, Out o) {
        return o.w("List<B> batch,\n", eachParameterDecl, ",");
    }

    private static /* synthetic */ Void lambda$generate$7(Out o, Integer i, InvocationsFinder.QueryPart __) {
        return o.w("Function<B, P", i + 1, "> pe", i + 1, ",\n", "TypeReadWrite<P", i + 1, "> prw", i + 1);
    }

    private static /* synthetic */ Void lambda$generate$6(List simpleParameters, Out o) {
        WriteNext body = Out.each(simpleParameters, ", ", (oo, i, __) -> oo.w("E", i + 1));
        return o.w("throws ", body);
    }

    private static /* synthetic */ Void lambda$generate$4(WriteNext tpList, Out o) {
        return o.w("<B, ", tpList, ">");
    }

    private static /* synthetic */ Void lambda$generate$3(Out o, Integer i, InvocationsFinder.QueryPart __) {
        return o.w("P", i + 1, ", E", i + 1, " extends Exception");
    }

    private static /* synthetic */ boolean lambda$generate$2(InvocationsFinder.QueryPart p) {
        return p instanceof InvocationsFinder.InParameter;
    }

    public static class Out {
        public final StringBuilder buffer;
        int offset = 0;
        int currentColumn = 0;

        public Out(StringBuilder buffer) {
            this.buffer = buffer;
        }

        private void writeChar(Character ch) {
            this.buffer.append(ch);
            if (ch.charValue() == '\n') {
                this.buffer.repeat(32, this.offset);
                this.currentColumn = this.offset;
            } else {
                ++this.currentColumn;
            }
        }

        private void writePart(String part) {
            for (int j = 0; j < part.length(); ++j) {
                this.writeChar(Character.valueOf(part.charAt(j)));
            }
        }

        public Void w(Object ... fragments) throws RuntimeException {
            for (Object value : fragments) {
                if (value instanceof WriteNext) {
                    WriteNext next = (WriteNext)value;
                    int oldOffset = this.offset;
                    this.offset = this.currentColumn;
                    next.write(this);
                    this.offset = oldOffset;
                    continue;
                }
                this.writePart(value.toString());
            }
            return null;
        }

        static <T> WriteNext each(List<T> list, String delimiter, EachNext<T> next) {
            return out -> {
                for (int i = 0; i < list.size(); ++i) {
                    next.write(out, i, list.get(i));
                    if (i == list.size() - 1) continue;
                    out.writePart(delimiter);
                }
                return null;
            };
        }

        static interface EachNext<T> {
            public Void write(Out var1, Integer var2, T var3);
        }
    }

    public static sealed interface FetchTo
    extends FetchMode
    permits FetchOne, FetchOneOrZero, FetchList, FetchStream {
        public GLangParser.FetchToField toField();
    }

    public record BatchedQuery(JCTree.JCExpression listDataExpression, JCTree.JCLambda extractor, List<InvocationsFinder.QueryPart> parts) implements Query
    {
    }

    public static sealed interface FetchMode
    permits FetchTo, FetchNone {
    }

    public record FetchNone() implements FetchMode
    {
    }

    public record FetchList(GLangParser.FetchToField toField) implements FetchTo
    {
    }

    public record FetchOne(GLangParser.FetchToField toField) implements FetchTo
    {
    }

    public record FetchOneOrZero(GLangParser.FetchToField toField) implements FetchTo
    {
    }

    public record FetchStream(GLangParser.FetchToField toField) implements FetchTo
    {
    }

    static interface WriteNext {
        public Void write(Out var1);
    }

    public record SingleQuery(List<InvocationsFinder.QueryPart> parts) implements Query
    {
    }

    public static enum SourceMode {
        DATASOURCE,
        CONNECTION;

    }

    public static sealed interface StatementMode
    permits StatementLike, AsCall {
    }

    public static sealed interface Query
    permits BatchedQuery, SingleQuery {
        public List<InvocationsFinder.QueryPart> parts();
    }

    public record AsCall() implements StatementMode
    {
    }

    public record AsDefault() implements StatementLike
    {
    }

    public static sealed interface AsGeneratedKeys
    extends StatementLike
    permits AsGeneratedKeysIndices, AsGeneratedKeysColumnNames {
    }

    public record AsGeneratedKeysColumnNames(String[] columnNames) implements AsGeneratedKeys
    {
    }

    public record AsGeneratedKeysIndices(int[] columnIndexes) implements AsGeneratedKeys
    {
    }

    public static sealed interface StatementLike
    extends StatementMode
    permits AsDefault, AsGeneratedKeys {
    }
}

