/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.StatementGenerator;
import org.jetbrains.annotations.Nullable;

public class MapperGenerator {
    private static List<GLangParser.ScalarField> flattenStartRow(List<GLangParser.Field> fields) {
        return fields.stream().flatMap(f -> {
            GLangParser.Field field = f;
            Objects.requireNonNull(field);
            GLangParser.Field selector0$temp = field;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ScalarField.class, GLangParser.ListOfScalarField.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    GLangParser.ListOfGroupField gf = (GLangParser.ListOfGroupField)selector0$temp;
                    yield MapperGenerator.flattenStartRow(gf.fields()).stream();
                }
                case 1 -> {
                    GLangParser.ScalarField sf = (GLangParser.ScalarField)selector0$temp;
                    yield Stream.of(sf);
                }
                case 2 -> {
                    GLangParser.ListOfScalarField lsf = (GLangParser.ListOfScalarField)selector0$temp;
                    yield Stream.of(new GLangParser.ScalarField(lsf.name(), lsf.nullMode(), lsf.binding()));
                }
            };
        }).toList();
    }

    private static Void dtoForGroupKeys(StatementGenerator.Out out, int level, int offset, List<GLangParser.Field> fields) {
        List<GLangParser.Aggregated> next = fields.stream().filter(f -> f instanceof GLangParser.Aggregated).map(f -> (GLangParser.Aggregated)((Object)f)).toList();
        if (!next.isEmpty()) {
            List<GLangParser.ScalarField> locals = fields.stream().filter(f -> f instanceof GLangParser.ScalarField).map(f -> (GLangParser.ScalarField)f).toList();
            StatementGenerator.WriteNext groupKeys = StatementGenerator.Out.each(locals, ",\n", (o, i, field) -> o.w(MapperGenerator.boxedClassName(field.binding().className()), " c", offset + i + 1));
            out.w("record G", level, "(\n", "    ", groupKeys, "\n", ") {}\n");
            int baseOffset = offset + locals.size();
            for (GLangParser.Aggregated n : next) {
                GLangParser.Aggregated aggregated;
                Objects.requireNonNull(n);
                int n2 = 0;
                List<GLangParser.Field> nextFields = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ListOfScalarField.class}, (Object)aggregated, n2)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        GLangParser.ListOfGroupField gf = (GLangParser.ListOfGroupField)aggregated;
                        yield gf.fields();
                    }
                    case 1 -> {
                        GLangParser.ListOfScalarField lsf = (GLangParser.ListOfScalarField)aggregated;
                        yield List.of(new GLangParser.ScalarField(lsf.name(), lsf.nullMode(), lsf.binding()));
                    }
                };
                MapperGenerator.dtoForGroupKeys(out, level + 1, baseOffset, nextFields);
                baseOffset += nextFields.size();
            }
        }
        return null;
    }

    private static Void nextOperations(StatementGenerator.Out out, int level, int offset, String dtoJavaClassName, List<GLangParser.Field> fields) {
        List<GLangParser.ScalarField> locals = fields.stream().filter(f -> f instanceof GLangParser.ScalarField).map(f -> (GLangParser.ScalarField)f).toList();
        List<GLangParser.Aggregated> next = fields.stream().filter(f -> f instanceof GLangParser.Aggregated).map(f -> (GLangParser.Aggregated)((Object)f)).toList();
        BiFunction<String, GLangParser.ScalarField, String> getField = (expr, st) -> MapperGenerator.wrapWithActualNullCheck(expr, st.nullMode());
        if (next.isEmpty()) {
            StatementGenerator.WriteNext dtoFilter = StatementGenerator.Out.each(locals, " ||\n", (o, i, __) -> o.w("java.util.Objects.nonNull(r.c", offset + i + 1, ")"));
            StatementGenerator.WriteNext dtoFieldsMapper = StatementGenerator.Out.each(locals, ",\n", (o, i, f) -> {
                String expr = "r.c" + (offset + i + 1);
                return o.w(getField.apply(expr, (GLangParser.ScalarField)f));
            });
            StatementGenerator.WriteNext dtoMapper = dtoJavaClassName.startsWith("List<") ? dtoFieldsMapper : o -> o.w("new ", dtoJavaClassName, "(\n", "    ", dtoFieldsMapper, "\n", ")");
            out.w(".filter(r ->\n", "    ", dtoFilter, "\n", ").map(r ->\n", "    ", dtoMapper, "\n", ").distinct()");
        } else {
            StatementGenerator.WriteNext keysFilter = StatementGenerator.Out.each(locals, " ||\n", (o, i, __) -> o.w("java.util.Objects.nonNull(g", level, ".getKey().c", offset + i + 1, ")"));
            StatementGenerator.WriteNext keysMapper = StatementGenerator.Out.each(locals, ",\n", (o, i, __) -> o.w("r.c", offset + i + 1));
            StatementGenerator.WriteNext dtoMapper = StatementGenerator.Out.each(locals, ",\n", (o, i, f) -> {
                String expr = "g" + level + ".getKey().c" + (offset + i + 1);
                return o.w(getField.apply(expr, (GLangParser.ScalarField)f));
            });
            StatementGenerator.WriteNext nextTransform = o -> {
                int baseOffset = offset + locals.size();
                for (int i = 0; i < next.size(); ++i) {
                    GLangParser.Aggregated selector0$temp;
                    GLangParser.ListOfScalarField lsf;
                    GLangParser.ListOfGroupField gf;
                    GLangParser.Aggregated aggregated;
                    GLangParser.Aggregated n = (GLangParser.Aggregated)next.get(i);
                    Objects.requireNonNull(n);
                    int n2 = 0;
                    List<GLangParser.Field> nextFields = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ListOfScalarField.class}, (Object)aggregated, n2)) {
                        default -> throw new MatchException(null, null);
                        case 0 -> {
                            gf = (GLangParser.ListOfGroupField)aggregated;
                            yield gf.fields();
                        }
                        case 1 -> {
                            lsf = (GLangParser.ListOfScalarField)aggregated;
                            yield List.of(new GLangParser.ScalarField(lsf.name(), lsf.nullMode(), lsf.binding()));
                        }
                    };
                    o.w("g", level, ".getValue().stream()");
                    Objects.requireNonNull(n);
                    int index$1 = 0;
                    MapperGenerator.nextOperations(out, level + 1, baseOffset, (String)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ListOfScalarField.class}, (Object)selector0$temp, index$1)) {
                        default -> throw new MatchException(null, null);
                        case 0 -> {
                            gf = (GLangParser.ListOfGroupField)selector0$temp;
                            yield gf.newJavaClassName();
                        }
                        case 1 -> {
                            lsf = (GLangParser.ListOfScalarField)selector0$temp;
                            yield "List<" + lsf.binding().className() + ">";
                        }
                    }), nextFields);
                    o.w(".toList()");
                    if (i != next.size() - 1) {
                        o.w(",\n");
                    }
                    baseOffset += nextFields.size();
                }
                return null;
            };
            out.w(".collect(\n", "    java.util.stream.Collectors.groupingBy(\n", "        r -> new G", level, "(\n", "            ", keysMapper, "\n", "        ), java.util.LinkedHashMap::new, Collectors.toList()\n", "    )\n", ").entrySet().stream()\n", ".filter(g", level, " ->\n", "    ", keysFilter, "\n", ").map(g", level, " ->\n", "    new ", dtoJavaClassName, "(\n", "        ", dtoMapper, ",\n", "        ", nextTransform, "\n", "    )\n", ")");
        }
        return null;
    }

    private static String wrapWithActualNullCheck(String expr, GLangParser.NullMode nullMode) {
        return nullMode != GLangParser.NullMode.EXACTLY_NULLABLE ? "EvenSoNullPointerException.check(" + expr + ")" : expr;
    }

    static String boxedClassName(String className) {
        return switch (className) {
            case "boolean" -> Boolean.class.getName();
            case "byte" -> Byte.class.getName();
            case "char" -> Character.class.getName();
            case "short" -> Short.class.getName();
            case "int" -> Integer.class.getName();
            case "long" -> Long.class.getName();
            case "float" -> Float.class.getName();
            case "double" -> Double.class.getName();
            default -> className;
        };
    }

    public static void generate(StatementGenerator.Out out, GLangParser.FetchToField toType, @Nullable int[] outParametersNumbers, Function<String, String> typeToRwClass) {
        StatementGenerator.WriteNext mapFields;
        StatementGenerator.WriteNext groupTransform;
        StatementGenerator.WriteNext extraDto;
        String from = outParametersNumbers != null ? "stmt" : "rs";
        BiFunction<GLangParser.ScalarField, Integer, String> getField = (t, i) -> {
            int j = outParametersNumbers == null ? i : outParametersNumbers[i - 1];
            return "new " + (String)typeToRwClass.apply(t.binding().className()) + "().get(" + from + "," + j + ")";
        };
        GLangParser.FetchToField fetchToField = toType;
        Objects.requireNonNull(fetchToField);
        GLangParser.FetchToField fetchToField2 = fetchToField;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ScalarField.class}, (Object)fetchToField2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String toDto;
                GLangParser.ListOfGroupField lgf = (GLangParser.ListOfGroupField)fetchToField2;
                List<GLangParser.ScalarField> flattened = MapperGenerator.flattenStartRow(lgf.fields());
                boolean hasInnerAggregating = lgf.fields().stream().anyMatch(f -> f instanceof GLangParser.Aggregated);
                StatementGenerator.WriteNext eachField = StatementGenerator.Out.each(flattened, ",\n", (o, i, field) -> {
                    String expr = (String)getField.apply((GLangParser.ScalarField)field, i + 1);
                    return o.w(hasInnerAggregating ? expr : MapperGenerator.wrapWithActualNullCheck(expr, field.nullMode()));
                });
                if (hasInnerAggregating) {
                    StatementGenerator.WriteNext rowFields = StatementGenerator.Out.each(flattened, ",\n", (o, i, field) -> o.w(MapperGenerator.boxedClassName(field.binding().className()), " c", i + 1));
                    StatementGenerator.WriteNext groupKeysDto = o -> MapperGenerator.dtoForGroupKeys(o, 1, 0, lgf.fields());
                    toDto = "Row";
                    extraDto = o -> o.w("record Row(\n", "    ", rowFields, "\n", ") {}\n", groupKeysDto, "\n", "\n");
                    groupTransform = o -> MapperGenerator.nextOperations(o, 1, 0, lgf.newJavaClassName(), lgf.fields());
                } else {
                    toDto = lgf.newJavaClassName();
                    extraDto = __ -> null;
                    groupTransform = __ -> null;
                }
                mapFields = o -> o.w("new ", toDto, " (\n", "    ", eachField, "\n", ")");
                break;
            }
            case 1: {
                GLangParser.ScalarField sf = (GLangParser.ScalarField)fetchToField2;
                mapFields = o -> o.w(MapperGenerator.wrapWithActualNullCheck((String)getField.apply(sf, 1), sf.nullMode()));
                extraDto = __ -> null;
                groupTransform = __ -> null;
            }
        }
        if (outParametersNumbers != null) {
            out.w("var mapped = ", mapFields, ";");
        } else {
            out.w(extraDto, "\n", "var mapped = Stream.iterate(\n", "    rs, t -> {\n", "        try {\n", "            return t.next();\n", "        } catch (SQLException e) {\n", "            throw source.mapException(e);\n", "        }\n", "    }, t -> t\n", ").map(t -> {\n", "    try {\n", "        return\n", "            ", mapFields, ";\n", "    } catch (SQLException e) {\n", "        throw source.mapException(e);\n", "    }\n", "})\n", groupTransform, ";\n");
        }
    }
}

