/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.truej.sql.compiler.ConfigurationParser;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.InvocationsFinder;
import net.truej.sql.compiler.StatementGenerator;
import net.truej.sql.compiler.TrueSqlAnnotationProcessor;
import net.truej.sql.compiler.TrueSqlPlugin;
import org.jetbrains.annotations.Nullable;

public class JdbcMetadataFetcher {
    private static boolean isDriversLoaded = false;

    private static boolean isUppercaseOnly(String str) {
        return str.chars().filter(ch -> ch != 95).allMatch(Character::isUpperCase);
    }

    private static boolean isGLangExpression(String str) {
        return str.contains(".") || str.contains(":t");
    }

    static String pgGetBaseColumnName(ResultSetMetaData mt, int i) {
        try {
            return (String)mt.getClass().getMethod("getBaseColumnName", Integer.TYPE).invoke((Object)mt, i);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getColumnName(String onDatabase, ResultSetMetaData mt, int i) throws SQLException {
        return switch (onDatabase) {
            case "PostgreSQL" -> JdbcMetadataFetcher.pgGetBaseColumnName(mt, i);
            case "HSQL Database Engine" -> {
                String name = mt.getColumnName(i);
                if (JdbcMetadataFetcher.isUppercaseOnly(name)) {
                    yield name.toLowerCase();
                }
                yield name;
            }
            case "Oracle", "Microsoft SQL Server" -> null;
            default -> mt.getColumnName(i);
        };
    }

    private static List<SqlColumnMetadata> fetchColumns(final String onDatabase, final ResultSetMetaData rMetadata) throws SQLException {
        if (rMetadata == null) {
            return null;
        }
        final Function<String, String> fixedColumnLabel = label -> {
            if (onDatabase.equals("MySQL") && label == null) {
                return "";
            }
            if (onDatabase.equals("HSQL Database Engine") || onDatabase.equals("Oracle")) {
                if (JdbcMetadataFetcher.isGLangExpression(label)) {
                    return label;
                }
                return JdbcMetadataFetcher.isUppercaseOnly(label) ? label.toLowerCase() : label;
            }
            if (onDatabase.equals("Microsoft SQL Server") && label.startsWith(":tnull")) {
                return ":t?" + label.substring(6);
            }
            return label;
        };
        return new ArrayList<SqlColumnMetadata>(){
            {
                for (int i = 1; i < rMetadata.getColumnCount() + 1; ++i) {
                    String string2 = rMetadata.getColumnClassName(i);
                    String string3 = rMetadata.getColumnTypeName(i);
                    int n = rMetadata.getColumnType(i);
                    int n2 = rMetadata.getScale(i);
                    int n3 = rMetadata.getPrecision(i);
                    String string4 = JdbcMetadataFetcher.getColumnName(onDatabase, rMetadata, i);
                    String string5 = (String)fixedColumnLabel.apply(rMetadata.getColumnLabel(i));
                    this.add(new SqlColumnMetadata(string2, string3, n, n2, n3, string4, string5, switch (rMetadata.isNullable(i)) {
                        case 0 -> GLangParser.NullMode.EXACTLY_NOT_NULL;
                        case 1 -> GLangParser.NullMode.EXACTLY_NULLABLE;
                        default -> GLangParser.NullMode.DEFAULT_NOT_NULL;
                    }));
                }
            }
        };
    }

    private static List<SqlParameterMetadata> fetchParameters(final ParameterMetaData pmt) throws SQLException {
        return new ArrayList<SqlParameterMetadata>(){
            {
                for (int i = 1; i < pmt.getParameterCount() + 1; ++i) {
                    String string = pmt.getParameterClassName(i);
                    String string2 = pmt.getParameterTypeName(i);
                    int n = pmt.getParameterType(i);
                    int n2 = pmt.getScale(i);
                    int n3 = pmt.getPrecision(i);
                    this.add(new SqlParameterMetadata(string, string2, n, n2, n3, switch (pmt.isNullable(i)) {
                        case 0 -> GLangParser.NullMode.EXACTLY_NOT_NULL;
                        case 1 -> GLangParser.NullMode.EXACTLY_NULLABLE;
                        default -> GLangParser.NullMode.DEFAULT_NOT_NULL;
                    }, switch (pmt.getParameterMode(i)) {
                        case 2 -> TrueSqlPlugin.ParameterMode.INOUT;
                        case 4 -> TrueSqlPlugin.ParameterMode.OUT;
                        default -> TrueSqlPlugin.ParameterMode.IN;
                    }));
                }
            }
        };
    }

    static JdbcMetadata fetch(String url, String username, String password, StatementGenerator.Query queryMode, StatementGenerator.StatementMode statementMode) throws SQLException {
        String query = queryMode.parts().stream().map(p -> {
            InvocationsFinder.QueryPart queryPart = p;
            Objects.requireNonNull(queryPart);
            InvocationsFinder.QueryPart selector0$temp = queryPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InvocationsFinder.SingleParameter.class, InvocationsFinder.TextPart.class, InvocationsFinder.UnfoldParameter.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    InvocationsFinder.SingleParameter __ = (InvocationsFinder.SingleParameter)selector0$temp;
                    yield "?";
                }
                case 1 -> {
                    InvocationsFinder.TextPart tp = (InvocationsFinder.TextPart)selector0$temp;
                    yield tp.text();
                }
                case 2 -> {
                    InvocationsFinder.UnfoldParameter u = (InvocationsFinder.UnfoldParameter)selector0$temp;
                    int n = StatementGenerator.unfoldArgumentsCount(u.extractor());
                    yield IntStream.range(0, n).mapToObj(__ -> "?").collect(Collectors.joining(", ", "(", ")"));
                }
            };
        }).collect(Collectors.joining());
        if (!isDriversLoaded) {
            isDriversLoaded = true;
            for (Driver driver : ServiceLoader.load(Driver.class, TrueSqlAnnotationProcessor.class.getClassLoader())) {
                DriverManager.registerDriver(driver);
            }
        }
        try (Connection connection = DriverManager.getConnection(url, username, password);){
            JdbcMetadata jdbcMetadata;
            block28: {
                StatementGenerator.StatementMode statementMode2 = statementMode;
                Objects.requireNonNull(statementMode2);
                StatementGenerator.StatementMode statementMode3 = statementMode2;
                int n = 0;
                PreparedStatement stmt = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StatementGenerator.AsDefault.class, StatementGenerator.AsCall.class, StatementGenerator.AsGeneratedKeysIndices.class, StatementGenerator.AsGeneratedKeysColumnNames.class}, (Object)statementMode3, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        StatementGenerator.AsDefault __ = (StatementGenerator.AsDefault)statementMode3;
                        yield connection.prepareStatement(query);
                    }
                    case 1 -> {
                        StatementGenerator.AsCall __ = (StatementGenerator.AsCall)statementMode3;
                        yield connection.prepareCall(query);
                    }
                    case 2 -> {
                        StatementGenerator.AsGeneratedKeysIndices gk = (StatementGenerator.AsGeneratedKeysIndices)statementMode3;
                        yield connection.prepareStatement(query, gk.columnIndexes());
                    }
                    case 3 -> {
                        StatementGenerator.AsGeneratedKeysColumnNames gk = (StatementGenerator.AsGeneratedKeysColumnNames)statementMode3;
                        yield connection.prepareStatement(query, gk.columnNames());
                    }
                };
                try {
                    List<SqlParameterMetadata> parameters;
                    List<SqlColumnMetadata> columns;
                    String onDatabase = connection.getMetaData().getDatabaseProductName();
                    if (onDatabase.equals("MySQL") && statementMode instanceof StatementGenerator.AsCall) {
                        columns = null;
                    } else if (onDatabase.equals("Oracle") && (statementMode instanceof StatementGenerator.AsGeneratedKeysIndices || statementMode instanceof StatementGenerator.AsGeneratedKeysColumnNames)) {
                        stmt.getMetaData();
                        columns = null;
                    } else {
                        columns = !(!onDatabase.equals("MySQL") && !onDatabase.equals("MariaDB") || !(statementMode instanceof StatementGenerator.AsGeneratedKeysIndices) && !(statementMode instanceof StatementGenerator.AsGeneratedKeysColumnNames)) ? JdbcMetadataFetcher.fetchColumns(onDatabase, stmt.getGeneratedKeys().getMetaData()) : JdbcMetadataFetcher.fetchColumns(onDatabase, stmt.getMetaData());
                    }
                    if (onDatabase.equals("MySQL")) {
                        parameters = null;
                    } else {
                        List<SqlParameterMetadata> parsed;
                        try {
                            parsed = JdbcMetadataFetcher.fetchParameters(stmt.getParameterMetaData());
                        }
                        catch (SQLFeatureNotSupportedException e) {
                            parsed = null;
                        }
                        parameters = parsed;
                    }
                    jdbcMetadata = new JdbcMetadata(onDatabase, columns, parameters);
                    if (stmt == null) break block28;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return jdbcMetadata;
        }
    }

    static void checkConstraint(JCTree tree, ConfigurationParser.ParsedConfiguration config, @Nullable String catalogName, @Nullable String schemaName, String tableName, String constraintName) throws SQLException {
        try (Connection connection = DriverManager.getConnection(config.url(), config.username(), config.password());){
            String onDatabase = connection.getMetaData().getDatabaseProductName();
            if (catalogName == null) {
                catalogName = onDatabase.equals("Oracle") ? "" : (onDatabase.equals("MySQL") || onDatabase.equals("MariaDB") ? "def" : connection.getCatalog());
            }
            if (schemaName == null) {
                schemaName = onDatabase.equals("MySQL") || onDatabase.equals("MariaDB") ? connection.getCatalog() : connection.getSchema();
            }
            String query = "select\n    '', ''\nfrom information_schema.table_constraints\nwhere\n    upper(TABLE_CATALOG)   = upper(?) and\n    upper(TABLE_SCHEMA)    = upper(?) and\n    upper(TABLE_NAME)      = upper(?) and\n    upper(CONSTRAINT_NAME) = upper(?)";
            if (onDatabase.equals("MySQL") || onDatabase.equals("MariaDB")) {
                query = "select\n    '', ?\nfrom information_schema.table_constraints\nwhere\n    upper(TABLE_SCHEMA)    = upper(?) and\n    upper(TABLE_NAME)      = upper(?) and\n    upper(CONSTRAINT_NAME) = upper(?)\n";
            }
            if (onDatabase.equals("Oracle")) {
                query = "select\n    '', ?\nfrom all_constraints\nwhere\n    upper(OWNER)           = upper(?) and\n    upper(TABLE_NAME)      = upper(?) and\n    upper(CONSTRAINT_NAME) = upper(?)\n";
            }
            PreparedStatement stmt = connection.prepareStatement(query);
            stmt.setString(1, catalogName);
            stmt.setString(2, schemaName);
            stmt.setString(3, tableName);
            stmt.setString(4, constraintName);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new TrueSqlPlugin.ValidationException(tree, "constraint not found");
            }
        }
    }

    record JdbcMetadata(String onDatabase, @Nullable List<SqlColumnMetadata> columns, @Nullable List<SqlParameterMetadata> parameters) {
    }

    public record SqlParameterMetadata(String javaClassName, String sqlTypeName, int sqlType, int scale, int precision, GLangParser.NullMode nullMode, TrueSqlPlugin.ParameterMode mode) {
    }

    public record SqlColumnMetadata(String javaClassName, String sqlTypeName, int sqlType, int scale, int precision, @Nullable String columnName, String columnLabel, GLangParser.NullMode nullMode) {
    }
}

