/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.truej.sql.bindings.Standard;
import org.jetbrains.annotations.Nullable;

public class GLangParser {
    private static final Pattern SNAKE_TO_CAMEL_CASE_PATTERN = Pattern.compile("_(\\p{L})");

    public static List<Lexeme> lex(String input) {
        ArrayList<Lexeme> result = new ArrayList<Lexeme>();
        StringBuilder acc = new StringBuilder(32);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            Consumer<Lexeme> emitEscaped = lexeme -> {
                if (acc.isEmpty()) {
                    if (lexeme != null) {
                        result.add((Lexeme)lexeme);
                    }
                } else if (acc.charAt(acc.length() - 1) == '\\') {
                    acc.setCharAt(acc.length() - 1, ch);
                } else {
                    result.add(new Text(acc.toString()));
                    if (lexeme != null) {
                        result.add((Lexeme)lexeme);
                    }
                    acc.setLength(0);
                }
            };
            if (ch == '.') {
                emitEscaped.accept(new Dot());
                continue;
            }
            if (ch == ':') {
                emitEscaped.accept(new Colon());
                continue;
            }
            if (ch == '!') {
                emitEscaped.accept(new ExclamationMark());
                continue;
            }
            if (ch == '?') {
                emitEscaped.accept(new QuestionMark());
                continue;
            }
            if (Character.isWhitespace(ch)) {
                emitEscaped.accept(null);
                continue;
            }
            acc.append(ch);
        }
        if (!acc.isEmpty()) {
            result.add(new Text(acc.toString()));
        }
        result.add(new End());
        return result;
    }

    private static NullMode markToNullMode(NullabilityMark m) {
        NullabilityMark nullabilityMark = m;
        Objects.requireNonNull(nullabilityMark);
        NullabilityMark nullabilityMark2 = nullabilityMark;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExclamationMark.class, QuestionMark.class}, (Object)nullabilityMark2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ExclamationMark __ = (ExclamationMark)nullabilityMark2;
                yield NullMode.EXACTLY_NOT_NULL;
            }
            case 1 -> {
                QuestionMark __ = (QuestionMark)nullabilityMark2;
                yield NullMode.EXACTLY_NULLABLE;
            }
        };
    }

    public static Line parseLine(List<Lexeme> input) {
        int next;
        String javaClassNameHint;
        NullMode nullMode;
        if (input.get(0) instanceof Colon) {
            if (!input.get(1).equals(new Text("t"))) {
                throw new ParseException("Expected t but has " + String.valueOf(input.get(1)));
            }
            Lexeme lexeme = input.get(2);
            Objects.requireNonNull(lexeme);
            Lexeme lexeme2 = lexeme;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullabilityMark.class, Text.class}, (Object)lexeme2, n)) {
                case 0: {
                    NullabilityMark m = (NullabilityMark)lexeme2;
                    nullMode = GLangParser.markToNullMode(m);
                    javaClassNameHint = null;
                    next = 3;
                    break;
                }
                case 1: {
                    Text text = (Text)lexeme2;
                    javaClassNameHint = text.t;
                    Lexeme lexeme3 = input.get(3);
                    if (lexeme3 instanceof NullabilityMark) {
                        NullabilityMark m = (NullabilityMark)lexeme3;
                        nullMode = GLangParser.markToNullMode(m);
                        next = 4;
                        break;
                    }
                    nullMode = NullMode.DEFAULT_NOT_NULL;
                    next = 3;
                    break;
                }
                default: {
                    throw new ParseException("Expected TEXT or QUESTION_MARK or EXCLAMATION_MARK but has " + String.valueOf(input.get(2)));
                }
            }
        } else {
            nullMode = NullMode.DEFAULT_NOT_NULL;
            javaClassNameHint = null;
            next = 0;
        }
        return new Line(nullMode, javaClassNameHint, GLangParser.parseChain(input, next));
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public static Chain parseChain(List<Lexeme> input, int i) {
        Lexeme lexeme = input.get(i);
        Objects.requireNonNull(lexeme);
        Lexeme lexeme2 = lexeme;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{End.class, Text.class}, (Object)lexeme2, n)) {
            case 0: {
                End __ = (End)lexeme2;
                Chain chain = new Chain(null, null, null);
                return chain;
            }
            case 1: {
                Chain chain;
                Text t1 = (Text)lexeme2;
                Lexeme lexeme3 = input.get(i + 1);
                Objects.requireNonNull(lexeme3);
                Lexeme lexeme4 = lexeme3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{End.class, Dot.class, Text.class}, (Object)lexeme4, n2)) {
                    case 0: {
                        End __ = (End)lexeme4;
                        chain = new Chain(null, t1.t, null);
                        return chain;
                    }
                    case 1: {
                        Dot __ = (Dot)lexeme4;
                        chain = new Chain(null, t1.t, GLangParser.parseChain(input, i + 2));
                        return chain;
                    }
                    case 2: {
                        Text t2 = (Text)lexeme4;
                        Lexeme lexeme5 = input.get(i + 2);
                        Objects.requireNonNull(lexeme5);
                        Lexeme lexeme6 = lexeme5;
                        int n3 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{End.class, Dot.class}, (Object)lexeme6, n3)) {
                            case 0: {
                                End __ = (End)lexeme6;
                                chain = new Chain(t1.t, t2.t, null);
                                return chain;
                            }
                            case 1: {
                                Dot __ = (Dot)lexeme6;
                                chain = new Chain(t1.t, t2.t, GLangParser.parseChain(input, i + 3));
                                return chain;
                            }
                        }
                        throw new ParseException("expected END or DOT but has " + String.valueOf(input.get(i + 2)));
                    }
                }
                throw new ParseException("expected END or DOT or TEXT but has " + String.valueOf(input.get(i + 1)));
            }
        }
        throw new ParseException("expected END or TEXT but has " + String.valueOf(input.get(i)));
    }

    private static String makeFieldName(String columnName) {
        return SNAKE_TO_CAMEL_CASE_PATTERN.matcher(columnName).replaceAll(m -> m.group(1).toUpperCase());
    }

    private static List<Field> buildGroup(BindColumn bindColumn, List<NumberedColumn> lines) {
        List<NumberedColumn> locals = lines.stream().filter(nl -> nl.line.chain.next == null).toList();
        int baseNumber = locals.getFirst().n;
        for (int i = 0; i < locals.size(); ++i) {
            if (baseNumber + i == locals.get((int)i).n) continue;
            throw new ParseException("The declarations of the members of the group should run consecutively");
        }
        Stream<Field> localsChecked = locals.stream().map(nl -> {
            if (nl.line.chain.fieldName == null && nl.column.columnName == null) {
                throw new ParseException("Your database driver doest not provides column name (labels only). Field name required");
            }
            if (nl.line.chain.groupClassName != null) {
                throw new ParseException("Aggregated java class name not expected here");
            }
            String realFieldName = nl.line.chain.fieldName != null ? nl.line.chain.fieldName : nl.column.columnName;
            BindColumn.Result bound = bindColumn.bind(nl.column, nl.n, nl.line.javaClassNameHint, nl.line.nullMode);
            return new ScalarField(GLangParser.makeFieldName(realFieldName), bound.nullMode, bound.binding);
        });
        Stream<Record> next = lines.stream().filter(nl -> nl.line.chain.next != null).collect(Collectors.groupingBy(nl -> nl.line.chain.fieldName, LinkedHashMap::new, Collectors.toList())).entrySet().stream().map(group -> {
            List groupLines = (List)group.getValue();
            String groupFieldName = GLangParser.makeFieldName((String)group.getKey());
            if (groupLines.size() == 1) {
                NumberedColumn numbered = (NumberedColumn)groupLines.getFirst();
                if (numbered.line.chain.groupClassName != null) {
                    throw new ParseException("Dto class name not allowed for group with one element - thees groups converts to List<single group element class name>");
                }
                if (numbered.line.chain.next != null && numbered.line.chain.next.next != null) {
                    throw new ParseException("Inner groups not allowed for group with one element");
                }
                BindColumn.Result bound = bindColumn.bind(numbered.column, numbered.n, numbered.line.javaClassNameHint, numbered.line.nullMode);
                return new ListOfScalarField(groupFieldName, bound.nullMode, bound.binding);
            }
            String groupClassName = ((NumberedColumn)groupLines.getFirst()).line.chain.groupClassName;
            if (groupClassName == null) {
                throw new ParseException("Aggregated java class name required");
            }
            return new ListOfGroupField(groupFieldName, groupClassName, GLangParser.buildGroup(bindColumn, groupLines.stream().map(nl -> new NumberedColumn(nl.n, nl.column, new Line(nl.line.nullMode, nl.line.javaClassNameHint, nl.line.chain.next))).toList()));
        });
        return Stream.concat(localsChecked, next).toList();
    }

    public static List<Field> parseResultSetColumns(List<ColumnMetadata> columns, BindColumn bindColumn) {
        return GLangParser.buildGroup(bindColumn, IntStream.range(0, columns.size()).mapToObj(n -> {
            ColumnMetadata column = (ColumnMetadata)columns.get(n);
            return new NumberedColumn(n, column, GLangParser.parseLine(GLangParser.lex(column.columnLabel)));
        }).toList());
    }

    public record Dot() implements Lexeme
    {
        @Override
        public String toString() {
            return "DOT";
        }
    }

    public record Colon() implements Lexeme
    {
        @Override
        public String toString() {
            return "COLON";
        }
    }

    public record ExclamationMark() implements NullabilityMark
    {
        @Override
        public String toString() {
            return "EXCLAMATION_MARK";
        }
    }

    public record QuestionMark() implements NullabilityMark
    {
        @Override
        public String toString() {
            return "QUESTION_MARK";
        }
    }

    public record Text(String t) implements Lexeme
    {
        @Override
        public String toString() {
            return "TEXT(" + this.t + ")";
        }
    }

    public record End() implements Lexeme
    {
        @Override
        public String toString() {
            return "END";
        }
    }

    public static enum NullMode {
        EXACTLY_NULLABLE,
        DEFAULT_NOT_NULL,
        EXACTLY_NOT_NULL;

    }

    public static sealed interface Lexeme
    permits Text, Colon, Dot, NullabilityMark, End {
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }

    public static sealed interface NullabilityMark
    extends Lexeme
    permits QuestionMark, ExclamationMark {
    }

    public record Line(NullMode nullMode, @Nullable String javaClassNameHint, Chain chain) {
    }

    public record Chain(@Nullable String groupClassName, @Nullable String fieldName, @Nullable Chain next) {
    }

    public record NumberedColumn(int n, ColumnMetadata column, Line line) {
    }

    public static interface BindColumn {
        public Result bind(ColumnMetadata var1, int var2, @Nullable String var3, NullMode var4);

        public record Result(Standard.Binding binding, NullMode nullMode) {
        }
    }

    public record ColumnMetadata(NullMode nullMode, int sqlType, String sqlTypeName, String javaClassName, @Nullable String columnName, String columnLabel, int scale, int precision) {
    }

    public record ListOfScalarField(String name, NullMode nullMode, Standard.Binding binding) implements Field,
    Aggregated
    {
    }

    public record ListOfGroupField(String name, String newJavaClassName, List<Field> fields) implements FetchToField,
    Aggregated
    {
    }

    public record ScalarField(String name, NullMode nullMode, Standard.Binding binding) implements FetchToField
    {
    }

    static sealed interface Aggregated
    permits ListOfScalarField, ListOfGroupField {
    }

    public static sealed interface FetchToField
    extends Field
    permits ScalarField, ListOfGroupField {
    }

    public static sealed interface Field
    permits FetchToField, ListOfScalarField {
        public String name();
    }
}

