/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.truej.sql.bindings.Standard;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.TrueSqlPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingDtoParser {
    static GLangParser.Field parse(List<Standard.Binding> bindings, boolean isEntry, boolean isToList, String toFieldName, GLangParser.NullMode argumentNullMode, Name initName, Type dtoType) {
        Symbol.ClassSymbol cl;
        Symbol.TypeSymbol typeSymbol;
        if (dtoType.tsym.flatName().contentEquals(List.class.getName())) {
            if (dtoType.getTypeArguments().isEmpty()) {
                throw new ParseException("Raw list cannot be used as Dto or Dto field");
            }
            if (isToList) {
                throw new ParseException("value of List<List<...>> cannot be Dto field");
            }
            return ExistingDtoParser.parse(bindings, false, true, toFieldName, argumentNullMode, initName, (Type)dtoType.getTypeArguments().getFirst());
        }
        if (dtoType.isInterface()) {
            throw new ParseException("To Dto class cannot be interface");
        }
        if (!dtoType.tsym.getTypeParameters().isEmpty()) {
            throw new ParseException("To Dto class cannot be generic");
        }
        if (!dtoType.isPrimitive() && (typeSymbol = dtoType.tsym) instanceof Symbol.ClassSymbol && (cl = (Symbol.ClassSymbol)typeSymbol).isInner() && !cl.isStatic()) {
            throw new ParseException("To Dto class must be static if inner");
        }
        Standard.Binding binding = bindings.stream().filter(b -> b.className().equals(TrueSqlPlugin.typeToClassName(dtoType))).findFirst().orElse(null);
        if (binding != null) {
            GLangParser.NullMode nullMode;
            if (dtoType.isPrimitive()) {
                if (argumentNullMode == GLangParser.NullMode.EXACTLY_NULLABLE) {
                    throw new ParseException(isEntry ? "result of primitive type cannot be marked as Nullable" : "Dto field of primitive type cannot be marked as @Nullable");
                }
                if (argumentNullMode == GLangParser.NullMode.EXACTLY_NOT_NULL) {
                    throw new ParseException(isEntry ? "result of primitive type not needed to be marked as NotNull" : "Dto field of primitive type not needed to be marked as @NotNull");
                }
                nullMode = GLangParser.NullMode.EXACTLY_NOT_NULL;
            } else {
                nullMode = argumentNullMode;
            }
            return isToList ? new GLangParser.ListOfScalarField(toFieldName, nullMode, binding) : new GLangParser.ScalarField(toFieldName, nullMode, binding);
        }
        if (dtoType.isPrimitive() || !isEntry && !isToList) {
            throw new ParseException("has no type binding for " + TrueSqlPlugin.typeToClassName(dtoType));
        }
        if (argumentNullMode != GLangParser.NullMode.DEFAULT_NOT_NULL) {
            throw new ParseException("Nullable or NotNull hint not allowed for aggregated DTO");
        }
        Iterator<Symbol> allConstructors = dtoType.tsym.members().getSymbols(s -> {
            if (!(s instanceof Symbol.MethodSymbol)) return false;
            Symbol.MethodSymbol cons = (Symbol.MethodSymbol)s;
            if (!cons.name.equals(initName)) return false;
            if (!cons.params.nonEmpty()) return false;
            return true;
        }).iterator();
        if (!allConstructors.hasNext()) {
            throw new ParseException("non-empty args constructor not found");
        }
        Symbol.MethodSymbol constructor = (Symbol.MethodSymbol)allConstructors.next();
        if (allConstructors.hasNext()) {
            throw new ParseException("has more than one non-empty args constructor");
        }
        List<GLangParser.Field> fields = constructor.params.stream().map(p -> {
            if (p.type.tsym instanceof Symbol.ClassSymbol) {
                boolean isMarkedAsNullable = p.getAnnotation(Nullable.class) != null;
                boolean isMarkedAsNotNull = p.getAnnotation(NotNull.class) != null;
                return ExistingDtoParser.parse(bindings, false, false, p.name.toString(), isMarkedAsNullable ? GLangParser.NullMode.EXACTLY_NULLABLE : (isMarkedAsNotNull ? GLangParser.NullMode.EXACTLY_NOT_NULL : GLangParser.NullMode.DEFAULT_NOT_NULL), initName, p.type);
            }
            throw new ParseException("unexpected constructor parameter of kind: " + String.valueOf((Object)p.type.tsym.kind));
        }).toList();
        return new GLangParser.ListOfGroupField(toFieldName, dtoType.toString(), fields);
    }

    public static List<GLangParser.ScalarField> flattenedDtoType(GLangParser.Field field) {
        GLangParser.Field field2 = field;
        Objects.requireNonNull(field2);
        GLangParser.Field field3 = field2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ScalarField.class, GLangParser.ListOfGroupField.class, GLangParser.ListOfScalarField.class}, (Object)field3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                GLangParser.ScalarField sf = (GLangParser.ScalarField)field3;
                yield List.of(sf);
            }
            case 1 -> {
                GLangParser.ListOfGroupField lgf = (GLangParser.ListOfGroupField)field3;
                yield lgf.fields().stream().flatMap(f -> ExistingDtoParser.flattenedDtoType(f).stream()).toList();
            }
            case 2 -> {
                GLangParser.ListOfScalarField lsf = (GLangParser.ListOfScalarField)field3;
                yield List.of(new GLangParser.ScalarField(lsf.name(), lsf.nullMode(), lsf.binding()));
            }
        };
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }
}

