/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.truej.sql.compiler.GLangParser;
import net.truej.sql.compiler.StatementGenerator;
import net.truej.sql.compiler.TrueSqlPlugin;

public class DtoGenerator {
    private static String sourceCodeTypeForField(GLangParser.Field field) {
        GLangParser.Field field2 = field;
        Objects.requireNonNull(field2);
        GLangParser.Field field3 = field2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.Aggregated.class, GLangParser.ScalarField.class}, (Object)field3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                GLangParser.Aggregated ag;
                GLangParser.Aggregated v1 = ag = (GLangParser.Aggregated)((Object)field3);
                Objects.requireNonNull(v1);
                GLangParser.Aggregated var6_4 = v1;
                int var7_6 = 0;
                String v2 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GLangParser.ListOfGroupField.class, GLangParser.ListOfScalarField.class}, (Object)var6_4, var7_6)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        GLangParser.ListOfGroupField lgf = (GLangParser.ListOfGroupField)var6_4;
                        yield lgf.newJavaClassName();
                    }
                    case 1 -> {
                        GLangParser.ListOfScalarField lsf = (GLangParser.ListOfScalarField)var6_4;
                        yield TrueSqlPlugin.classNameToSourceCodeType(lsf.binding().className());
                    }
                };
                yield "List<" + v2 + ">";
            }
            case 1 -> {
                GLangParser.ScalarField sf = (GLangParser.ScalarField)field3;
                yield TrueSqlPlugin.classNameToSourceCodeType(sf.binding().className());
            }
        };
    }

    public static void generate(StatementGenerator.Out out, GLangParser.ListOfGroupField forGroup) {
        List<GLangParser.ListOfGroupField> nestedTypes = forGroup.fields().stream().filter(f -> f instanceof GLangParser.ListOfGroupField).map(f -> (GLangParser.ListOfGroupField)f).toList();
        StatementGenerator.WriteNext nestedDto = StatementGenerator.Out.each(nestedTypes, "\n", (o, __, at) -> {
            DtoGenerator.generate(o, at);
            return null;
        });
        StatementGenerator.WriteNext fieldDefinitions = StatementGenerator.Out.each(forGroup.fields(), "\n", (o, __, f) -> {
            String string;
            if (f instanceof GLangParser.ScalarField) {
                GLangParser.ScalarField st = (GLangParser.ScalarField)f;
                switch (st.nullMode()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EXACTLY_NULLABLE: {
                        string = "@Nullable ";
                        break;
                    }
                    case DEFAULT_NOT_NULL: {
                        string = "";
                        break;
                    }
                    case EXACTLY_NOT_NULL: {
                        string = "@NotNull ";
                        break;
                    }
                }
            } else {
                string = "";
            }
            String nullability = string;
            return o.w(nullability, "public final ", DtoGenerator.sourceCodeTypeForField(f), " ", f.name(), ";");
        });
        StatementGenerator.WriteNext constructorParameters = StatementGenerator.Out.each(forGroup.fields(), ",\n", (o, __, f) -> o.w(DtoGenerator.sourceCodeTypeForField(f), " ", f.name()));
        StatementGenerator.WriteNext constructorFieldAssignments = StatementGenerator.Out.each(forGroup.fields(), "\n", (o, __, f) -> o.w("this.", f.name(), " = ", f.name(), ";"));
        StatementGenerator.WriteNext equalsFieldComparisons = StatementGenerator.Out.each(forGroup.fields(), " &&\n", (o, __, f) -> o.w("java.util.Objects.equals(this.", f.name(), ", o.", f.name(), ")"));
        StatementGenerator.WriteNext hashCodeCalculations = StatementGenerator.Out.each(forGroup.fields(), "\n", (o, __, f) -> o.w("h = h * 59 + java.util.Objects.hashCode(this.", f.name(), ");"));
        StatementGenerator.WriteNext toStringGeneration = StatementGenerator.Out.each(forGroup.fields(), " +\n\", \" + ", (o, __, f) -> o.w("\"", f.name(), "=\" + ", f.name()));
        out.w(nestedDto, "\n", "public static class ", forGroup.newJavaClassName(), " {\n", "    ", fieldDefinitions, "\n", "\n", "    public ", forGroup.newJavaClassName(), "(\n", "        ", constructorParameters, "\n", "    ) {\n", "        ", constructorFieldAssignments, "\n", "    }", "\n", "    @Override public boolean equals(Object other) {\n", "        return this == other || (\n", "            other instanceof ", forGroup.newJavaClassName(), " o &&\n", "            ", equalsFieldComparisons, "\n", "        );\n", "    }\n", "\n", "    @Override public int hashCode() {\n", "        int h = 1;\n", "        ", hashCodeCalculations, "\n", "        return h;\n", "    }\n", "    @Override public String toString() {\n", "        return \"", forGroup.newJavaClassName(), "[\" +\n", "        ", toStringGeneration, "\n", "        + \"]\";\n", "    }\n", "}");
    }
}

