/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.truej.sql.bindings.Standard;
import net.truej.sql.compiler.BoundTypeExtractor;
import net.truej.sql.compiler.TrueSqlPlugin;
import net.truej.sql.config.Configuration;
import net.truej.sql.config.TypeBinding;
import net.truej.sql.config.TypeReadWrite;
import org.jetbrains.annotations.Nullable;

public class ConfigurationParser {
    @Nullable
    public static String findProperty(String propertyName) {
        String prop = System.getProperty(propertyName);
        if (prop != null) {
            return prop;
        }
        prop = System.getenv(propertyName);
        return prop;
    }

    public static ParsedConfiguration parseConfig(Symtab symtab, Names names, JCTree.JCCompilationUnit cu, Symbol.ClassSymbol annotated, BiConsumer<String, String> onPropertyParsed) {
        BiFunction<String, String, String> parseProperty = (parameterName, valueInAnnotation) -> {
            String propertyName = "truesql." + annotated.className() + "." + parameterName;
            String prop = ConfigurationParser.findProperty(propertyName);
            if (prop == null && !valueInAnnotation.equals("__MAGIC__TRUE_SQL_PROPERTY_NOT_DEFINED")) {
                prop = valueInAnnotation;
            }
            onPropertyParsed.accept(propertyName, prop);
            return prop;
        };
        Configuration config = null;
        Attribute.Array typeBindingAttrib = null;
        for (Attribute.Compound am : annotated.getAnnotationMirrors()) {
            if (!am.getAnnotationType().toString().equals(Configuration.class.getName())) continue;
            config = annotated.getAnnotation(Configuration.class);
            typeBindingAttrib = (Attribute.Array)am.member(names.fromString("typeBindings"));
        }
        if (config != null) {
            ArrayList<Standard.Binding> bindings = new ArrayList<Standard.Binding>(Standard.bindings);
            for (int i = 0; i < config.typeBindings().length; ++i) {
                String compatibleSqlTypeName;
                TypeBinding tb = config.typeBindings()[i];
                Symbol.ClassSymbol rwClassSym = symtab.enterClass(cu.modle, ((Attribute.Class)((Attribute.Compound)typeBindingAttrib.values[i]).member((Name)names.fromString((String)"rw"))).classType.tsym.flatName());
                rwClassSym.complete();
                Type bound = BoundTypeExtractor.extract(symtab.getClass(cu.modle, names.fromString(TypeReadWrite.class.getName())), rwClassSym);
                ArrayList<String> errors = new ArrayList<String>();
                if (rwClassSym.isAbstract()) {
                    errors.add("cannot be abstract");
                }
                if (rwClassSym.isInner() && !rwClassSym.isStatic()) {
                    errors.add("if inner then required to be static also");
                }
                if (!rwClassSym.members_field.anyMatch(sym -> {
                    if (!(sym instanceof Symbol.MethodSymbol)) return false;
                    Symbol.MethodSymbol m = (Symbol.MethodSymbol)sym;
                    if (!m.name.equals(names.fromString("<init>"))) return false;
                    if (!m.params.isEmpty()) return false;
                    if (!m.isPublic()) return false;
                    return true;
                })) {
                    errors.add("must have public no-arg constructor");
                }
                if (!errors.isEmpty()) {
                    throw new ParseException("For source " + annotated.className() + ": RW class " + String.valueOf(rwClassSym.flatName()) + ": " + String.join((CharSequence)", ", errors));
                }
                Integer compatibleSqlType = tb.compatibleSqlType() == 1996 ? null : Integer.valueOf(tb.compatibleSqlType());
                String string = compatibleSqlTypeName = tb.compatibleSqlTypeName().equals("__MAGIC__TRUE_SQL_PROPERTY_NOT_DEFINED") ? null : tb.compatibleSqlTypeName();
                if (compatibleSqlType != null && compatibleSqlTypeName != null) {
                    throw new ParseException("For source " + annotated.className() + ": compatibleSqlType and compatibleSqlTypeName cannot be specified at the same time");
                }
                bindings.add(new Standard.Binding(TrueSqlPlugin.typeToClassName(bound), rwClassSym.flatName().toString(), compatibleSqlType, compatibleSqlTypeName));
            }
            return new ParsedConfiguration(parseProperty.apply("url", config.checks().url()), parseProperty.apply("username", config.checks().username()), parseProperty.apply("password", config.checks().password()), bindings);
        }
        return new ParsedConfiguration(null, null, null, Standard.bindings);
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(String message) {
            super(message);
        }
    }

    public record ParsedConfiguration(String url, String username, String password, List<Standard.Binding> typeBindings) {
    }
}

