/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.compiler;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.util.Locale;
import java.util.ResourceBundle;

public class CompilerMessages {
    private final Log javacLog;
    private final JCDiagnostic.Factory diagnosticsFactory;

    public CompilerMessages(Context context) {
        this.javacLog = Log.instance(context);
        this.diagnosticsFactory = JCDiagnostic.Factory.instance(context);
        JavacMessages javacMessages = JavacMessages.instance(context);
        ResourceBundle bundle = ResourceBundle.getBundle("net.truej.sql.compiler.MessagesBundle_en", new Locale("en", "US"));
        javacMessages.add(locale -> bundle);
    }

    public void write(JCTree.JCCompilationUnit cu, JCTree forTree, JCDiagnostic.DiagnosticType type, String message) {
        this.javacLog.report(this.diagnosticsFactory.create(new DiagnosticSource(cu.getSourceFile(), this.javacLog), new JCDiagnostic.SimpleDiagnosticPosition(forTree.pos), JCDiagnostic.DiagnosticInfo.of(type, "compiler", "tsql", message)));
    }
}

