/*
 * Decompiled with CFR 0.152.
 */
package net.truej.sql.bindings;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.truej.sql.config.TypeReadWrite;

public class FloatReadWrite
implements TypeReadWrite<Float> {
    @Override
    public Float get(ResultSet rs, int columnIndex) throws SQLException {
        float value = rs.getFloat(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return Float.valueOf(value);
    }

    @Override
    public void set(PreparedStatement stmt, int parameterIndex, Float value) throws SQLException {
        if (value == null) {
            stmt.setNull(parameterIndex, 7);
        } else {
            stmt.setFloat(parameterIndex, value.floatValue());
        }
    }

    @Override
    public Float get(CallableStatement stmt, int parameterIndex) throws SQLException {
        float v = stmt.getFloat(parameterIndex);
        if (stmt.wasNull()) {
            return null;
        }
        return Float.valueOf(v);
    }

    @Override
    public void registerOutParameter(CallableStatement stmt, int parameterIndex) throws SQLException {
        stmt.registerOutParameter(parameterIndex, 7);
    }
}

