/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.KillmailAttacker;
import net.troja.eve.esi.model.KillmailVictim;

@ApiModel(description="200 ok object")
public class KillmailResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ATTACKERS = "attackers";
    @SerializedName(value="attackers")
    private List<KillmailAttacker> attackers = new ArrayList<KillmailAttacker>();
    public static final String SERIALIZED_NAME_KILLMAIL_ID = "killmail_id";
    @SerializedName(value="killmail_id")
    private Integer killmailId;
    public static final String SERIALIZED_NAME_KILLMAIL_TIME = "killmail_time";
    @SerializedName(value="killmail_time")
    private OffsetDateTime killmailTime;
    public static final String SERIALIZED_NAME_MOON_ID = "moon_id";
    @SerializedName(value="moon_id")
    private Integer moonId;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_VICTIM = "victim";
    @SerializedName(value="victim")
    private KillmailVictim victim;
    public static final String SERIALIZED_NAME_WAR_ID = "war_id";
    @SerializedName(value="war_id")
    private Integer warId;

    public KillmailResponse attackers(List<KillmailAttacker> attackers) {
        this.attackers = attackers;
        return this;
    }

    public KillmailResponse addAttackersItem(KillmailAttacker attackersItem) {
        this.attackers.add(attackersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="attackers array")
    public List<KillmailAttacker> getAttackers() {
        return this.attackers;
    }

    public void setAttackers(List<KillmailAttacker> attackers) {
        this.attackers = attackers;
    }

    public KillmailResponse killmailId(Integer killmailId) {
        this.killmailId = killmailId;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the killmail")
    public Integer getKillmailId() {
        return this.killmailId;
    }

    public void setKillmailId(Integer killmailId) {
        this.killmailId = killmailId;
    }

    public KillmailResponse killmailTime(OffsetDateTime killmailTime) {
        this.killmailTime = killmailTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Time that the victim was killed and the killmail generated ")
    public OffsetDateTime getKillmailTime() {
        return this.killmailTime;
    }

    public void setKillmailTime(OffsetDateTime killmailTime) {
        this.killmailTime = killmailTime;
    }

    public KillmailResponse moonId(Integer moonId) {
        this.moonId = moonId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Moon if the kill took place at one")
    public Integer getMoonId() {
        return this.moonId;
    }

    public void setMoonId(Integer moonId) {
        this.moonId = moonId;
    }

    public KillmailResponse solarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    @ApiModelProperty(required=true, value="Solar system that the kill took place in ")
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public KillmailResponse victim(KillmailVictim victim) {
        this.victim = victim;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public KillmailVictim getVictim() {
        return this.victim;
    }

    public void setVictim(KillmailVictim victim) {
        this.victim = victim;
    }

    public KillmailResponse warId(Integer warId) {
        this.warId = warId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="War if the killmail is generated in relation to an official war ")
    public Integer getWarId() {
        return this.warId;
    }

    public void setWarId(Integer warId) {
        this.warId = warId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KillmailResponse killmailResponse = (KillmailResponse)o;
        return Objects.equals(this.attackers, killmailResponse.attackers) && Objects.equals(this.killmailId, killmailResponse.killmailId) && Objects.equals(this.killmailTime, killmailResponse.killmailTime) && Objects.equals(this.moonId, killmailResponse.moonId) && Objects.equals(this.solarSystemId, killmailResponse.solarSystemId) && Objects.equals(this.victim, killmailResponse.victim) && Objects.equals(this.warId, killmailResponse.warId);
    }

    public int hashCode() {
        return Objects.hash(this.attackers, this.killmailId, this.killmailTime, this.moonId, this.solarSystemId, this.victim, this.warId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KillmailResponse {\n");
        sb.append("    attackers: ").append(this.toIndentedString(this.attackers)).append("\n");
        sb.append("    killmailId: ").append(this.toIndentedString(this.killmailId)).append("\n");
        sb.append("    killmailTime: ").append(this.toIndentedString(this.killmailTime)).append("\n");
        sb.append("    moonId: ").append(this.toIndentedString(this.moonId)).append("\n");
        sb.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        sb.append("    victim: ").append(this.toIndentedString(this.victim)).append("\n");
        sb.append("    warId: ").append(this.toIndentedString(this.warId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

