/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.PlanetContent;
import net.troja.eve.esi.model.PlanetExtractorDetails;
import net.troja.eve.esi.model.PlanetFactoryDetails;

@ApiModel(description="pin object")
public class PlanetPin
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTENTS = "contents";
    @SerializedName(value="contents")
    private List<PlanetContent> contents = null;
    public static final String SERIALIZED_NAME_EXPIRY_TIME = "expiry_time";
    @SerializedName(value="expiry_time")
    private OffsetDateTime expiryTime;
    public static final String SERIALIZED_NAME_EXTRACTOR_DETAILS = "extractor_details";
    @SerializedName(value="extractor_details")
    private PlanetExtractorDetails extractorDetails;
    public static final String SERIALIZED_NAME_FACTORY_DETAILS = "factory_details";
    @SerializedName(value="factory_details")
    private PlanetFactoryDetails factoryDetails;
    public static final String SERIALIZED_NAME_INSTALL_TIME = "install_time";
    @SerializedName(value="install_time")
    private OffsetDateTime installTime;
    public static final String SERIALIZED_NAME_LAST_CYCLE_START = "last_cycle_start";
    @SerializedName(value="last_cycle_start")
    private OffsetDateTime lastCycleStart;
    public static final String SERIALIZED_NAME_LATITUDE = "latitude";
    @SerializedName(value="latitude")
    private Float latitude;
    public static final String SERIALIZED_NAME_LONGITUDE = "longitude";
    @SerializedName(value="longitude")
    private Float longitude;
    public static final String SERIALIZED_NAME_PIN_ID = "pin_id";
    @SerializedName(value="pin_id")
    private Long pinId;
    public static final String SERIALIZED_NAME_SCHEMATIC_ID = "schematic_id";
    @SerializedName(value="schematic_id")
    private Integer schematicId;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;

    public PlanetPin contents(List<PlanetContent> contents) {
        this.contents = contents;
        return this;
    }

    public PlanetPin addContentsItem(PlanetContent contentsItem) {
        if (this.contents == null) {
            this.contents = new ArrayList<PlanetContent>();
        }
        this.contents.add(contentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="contents array")
    public List<PlanetContent> getContents() {
        return this.contents;
    }

    public void setContents(List<PlanetContent> contents) {
        this.contents = contents;
    }

    public PlanetPin expiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="expiry_time string")
    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    public PlanetPin extractorDetails(PlanetExtractorDetails extractorDetails) {
        this.extractorDetails = extractorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlanetExtractorDetails getExtractorDetails() {
        return this.extractorDetails;
    }

    public void setExtractorDetails(PlanetExtractorDetails extractorDetails) {
        this.extractorDetails = extractorDetails;
    }

    public PlanetPin factoryDetails(PlanetFactoryDetails factoryDetails) {
        this.factoryDetails = factoryDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlanetFactoryDetails getFactoryDetails() {
        return this.factoryDetails;
    }

    public void setFactoryDetails(PlanetFactoryDetails factoryDetails) {
        this.factoryDetails = factoryDetails;
    }

    public PlanetPin installTime(OffsetDateTime installTime) {
        this.installTime = installTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="install_time string")
    public OffsetDateTime getInstallTime() {
        return this.installTime;
    }

    public void setInstallTime(OffsetDateTime installTime) {
        this.installTime = installTime;
    }

    public PlanetPin lastCycleStart(OffsetDateTime lastCycleStart) {
        this.lastCycleStart = lastCycleStart;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="last_cycle_start string")
    public OffsetDateTime getLastCycleStart() {
        return this.lastCycleStart;
    }

    public void setLastCycleStart(OffsetDateTime lastCycleStart) {
        this.lastCycleStart = lastCycleStart;
    }

    public PlanetPin latitude(Float latitude) {
        this.latitude = latitude;
        return this;
    }

    @ApiModelProperty(required=true, value="latitude number")
    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public PlanetPin longitude(Float longitude) {
        this.longitude = longitude;
        return this;
    }

    @ApiModelProperty(required=true, value="longitude number")
    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public PlanetPin pinId(Long pinId) {
        this.pinId = pinId;
        return this;
    }

    @ApiModelProperty(required=true, value="pin_id integer")
    public Long getPinId() {
        return this.pinId;
    }

    public void setPinId(Long pinId) {
        this.pinId = pinId;
    }

    public PlanetPin schematicId(Integer schematicId) {
        this.schematicId = schematicId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="schematic_id integer")
    public Integer getSchematicId() {
        return this.schematicId;
    }

    public void setSchematicId(Integer schematicId) {
        this.schematicId = schematicId;
    }

    public PlanetPin typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(required=true, value="type_id integer")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanetPin planetPin = (PlanetPin)o;
        return Objects.equals(this.contents, planetPin.contents) && Objects.equals(this.expiryTime, planetPin.expiryTime) && Objects.equals(this.extractorDetails, planetPin.extractorDetails) && Objects.equals(this.factoryDetails, planetPin.factoryDetails) && Objects.equals(this.installTime, planetPin.installTime) && Objects.equals(this.lastCycleStart, planetPin.lastCycleStart) && Objects.equals(this.latitude, planetPin.latitude) && Objects.equals(this.longitude, planetPin.longitude) && Objects.equals(this.pinId, planetPin.pinId) && Objects.equals(this.schematicId, planetPin.schematicId) && Objects.equals(this.typeId, planetPin.typeId);
    }

    public int hashCode() {
        return Objects.hash(this.contents, this.expiryTime, this.extractorDetails, this.factoryDetails, this.installTime, this.lastCycleStart, this.latitude, this.longitude, this.pinId, this.schematicId, this.typeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlanetPin {\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    expiryTime: ").append(this.toIndentedString(this.expiryTime)).append("\n");
        sb.append("    extractorDetails: ").append(this.toIndentedString(this.extractorDetails)).append("\n");
        sb.append("    factoryDetails: ").append(this.toIndentedString(this.factoryDetails)).append("\n");
        sb.append("    installTime: ").append(this.toIndentedString(this.installTime)).append("\n");
        sb.append("    lastCycleStart: ").append(this.toIndentedString(this.lastCycleStart)).append("\n");
        sb.append("    latitude: ").append(this.toIndentedString(this.latitude)).append("\n");
        sb.append("    longitude: ").append(this.toIndentedString(this.longitude)).append("\n");
        sb.append("    pinId: ").append(this.toIndentedString(this.pinId)).append("\n");
        sb.append("    schematicId: ").append(this.toIndentedString(this.schematicId)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

