/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardCorporationYesterdayKills;

@ApiModel(description="Top 10 rankings of corporations by number of kills from yesterday, last week and in total")
public class FactionWarfareLeaderboardCorporationsKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardCorporationActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardCorporationActiveTotalKills>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardCorporationLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardCorporationLastWeekKills>();
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardCorporationYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardCorporationYesterdayKills>();

    public FactionWarfareLeaderboardCorporationsKills activeTotal(List<FactionWarfareLeaderboardCorporationActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addActiveTotalItem(FactionWarfareLeaderboardCorporationActiveTotalKills activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations active in faction warfare by total kills. A corporation is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardCorporationActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardCorporationActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardCorporationsKills lastWeek(List<FactionWarfareLeaderboardCorporationLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addLastWeekItem(FactionWarfareLeaderboardCorporationLastWeekKills lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations by kills in the past week")
    public List<FactionWarfareLeaderboardCorporationLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardCorporationLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public FactionWarfareLeaderboardCorporationsKills yesterday(List<FactionWarfareLeaderboardCorporationYesterdayKills> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardCorporationsKills addYesterdayItem(FactionWarfareLeaderboardCorporationYesterdayKills yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 10 ranking of corporations by kills in the past day")
    public List<FactionWarfareLeaderboardCorporationYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardCorporationYesterdayKills> yesterday) {
        this.yesterday = yesterday;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardCorporationsKills factionWarfareLeaderboardCorporationsKills = (FactionWarfareLeaderboardCorporationsKills)o;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardCorporationsKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardCorporationsKills.lastWeek) && Objects.equals(this.yesterday, factionWarfareLeaderboardCorporationsKills.yesterday);
    }

    public int hashCode() {
        return Objects.hash(this.activeTotal, this.lastWeek, this.yesterday);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardCorporationsKills {\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

