/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.DogmaAttributeResponse;
import net.troja.eve.esi.model.DogmaDynamicItemsResponse;
import net.troja.eve.esi.model.DogmaEffectResponse;
import okhttp3.Call;

public class DogmaApi {
    private ApiClient localVarApiClient;

    public DogmaApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DogmaApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getDogmaAttributesCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/dogma/attributes/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDogmaAttributesValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDogmaAttributesCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getDogmaAttributes(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getDogmaAttributesWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getDogmaAttributesWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getDogmaAttributesValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDogmaAttributesAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getDogmaAttributesValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDogmaAttributesAttributeIdCall(Integer attributeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/dogma/attributes/{attribute_id}/".replaceAll("\\{attribute_id\\}", this.localVarApiClient.escapeString(attributeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDogmaAttributesAttributeIdValidateBeforeCall(Integer attributeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (attributeId == null) {
            throw new ApiException("Missing the required parameter 'attributeId' when calling getDogmaAttributesAttributeId(Async)");
        }
        Call localVarCall = this.getDogmaAttributesAttributeIdCall(attributeId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DogmaAttributeResponse getDogmaAttributesAttributeId(Integer attributeId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<DogmaAttributeResponse> localVarResp = this.getDogmaAttributesAttributeIdWithHttpInfo(attributeId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DogmaAttributeResponse> getDogmaAttributesAttributeIdWithHttpInfo(Integer attributeId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getDogmaAttributesAttributeIdValidateBeforeCall(attributeId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DogmaAttributeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDogmaAttributesAttributeIdAsync(Integer attributeId, String datasource, String ifNoneMatch, ApiCallback<DogmaAttributeResponse> _callback) throws ApiException {
        Call localVarCall = this.getDogmaAttributesAttributeIdValidateBeforeCall(attributeId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DogmaAttributeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDogmaDynamicItemsTypeIdItemIdCall(Long itemId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/dogma/dynamic/items/{type_id}/{item_id}/".replaceAll("\\{item_id\\}", this.localVarApiClient.escapeString(itemId.toString())).replaceAll("\\{type_id\\}", this.localVarApiClient.escapeString(typeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(Long itemId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (itemId == null) {
            throw new ApiException("Missing the required parameter 'itemId' when calling getDogmaDynamicItemsTypeIdItemId(Async)");
        }
        if (typeId == null) {
            throw new ApiException("Missing the required parameter 'typeId' when calling getDogmaDynamicItemsTypeIdItemId(Async)");
        }
        Call localVarCall = this.getDogmaDynamicItemsTypeIdItemIdCall(itemId, typeId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DogmaDynamicItemsResponse getDogmaDynamicItemsTypeIdItemId(Long itemId, Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<DogmaDynamicItemsResponse> localVarResp = this.getDogmaDynamicItemsTypeIdItemIdWithHttpInfo(itemId, typeId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DogmaDynamicItemsResponse> getDogmaDynamicItemsTypeIdItemIdWithHttpInfo(Long itemId, Integer typeId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(itemId, typeId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DogmaDynamicItemsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDogmaDynamicItemsTypeIdItemIdAsync(Long itemId, Integer typeId, String datasource, String ifNoneMatch, ApiCallback<DogmaDynamicItemsResponse> _callback) throws ApiException {
        Call localVarCall = this.getDogmaDynamicItemsTypeIdItemIdValidateBeforeCall(itemId, typeId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DogmaDynamicItemsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDogmaEffectsCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v1/dogma/effects/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDogmaEffectsValidateBeforeCall(String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDogmaEffectsCall(datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<Integer> getDogmaEffects(String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<Integer>> localVarResp = this.getDogmaEffectsWithHttpInfo(datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<Integer>> getDogmaEffectsWithHttpInfo(String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getDogmaEffectsValidateBeforeCall(datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDogmaEffectsAsync(String datasource, String ifNoneMatch, ApiCallback<List<Integer>> _callback) throws ApiException {
        Call localVarCall = this.getDogmaEffectsValidateBeforeCall(datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<Integer>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDogmaEffectsEffectIdCall(Integer effectId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/dogma/effects/{effect_id}/".replaceAll("\\{effect_id\\}", this.localVarApiClient.escapeString(effectId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDogmaEffectsEffectIdValidateBeforeCall(Integer effectId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (effectId == null) {
            throw new ApiException("Missing the required parameter 'effectId' when calling getDogmaEffectsEffectId(Async)");
        }
        Call localVarCall = this.getDogmaEffectsEffectIdCall(effectId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public DogmaEffectResponse getDogmaEffectsEffectId(Integer effectId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<DogmaEffectResponse> localVarResp = this.getDogmaEffectsEffectIdWithHttpInfo(effectId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<DogmaEffectResponse> getDogmaEffectsEffectIdWithHttpInfo(Integer effectId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getDogmaEffectsEffectIdValidateBeforeCall(effectId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<DogmaEffectResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDogmaEffectsEffectIdAsync(Integer effectId, String datasource, String ifNoneMatch, ApiCallback<DogmaEffectResponse> _callback) throws ApiException {
        Call localVarCall = this.getDogmaEffectsEffectIdValidateBeforeCall(effectId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<DogmaEffectResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

