/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class StatusResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_PLAYERS = "players";
    @SerializedName(value="players")
    private Integer players;
    public static final String SERIALIZED_NAME_SERVER_VERSION = "server_version";
    @SerializedName(value="server_version")
    private String serverVersion;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_VIP = "vip";
    @SerializedName(value="vip")
    private Boolean vip;

    public StatusResponse players(Integer players) {
        this.players = players;
        return this;
    }

    @ApiModelProperty(required=true, value="Current online player count")
    public Integer getPlayers() {
        return this.players;
    }

    public void setPlayers(Integer players) {
        this.players = players;
    }

    public StatusResponse serverVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="Running version as string")
    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public StatusResponse startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Server start timestamp")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public StatusResponse vip(Boolean vip) {
        this.vip = vip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the server is in VIP mode")
    public Boolean getVip() {
        return this.vip;
    }

    public void setVip(Boolean vip) {
        this.vip = vip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusResponse statusResponse = (StatusResponse)o;
        return Objects.equals(this.players, statusResponse.players) && Objects.equals(this.serverVersion, statusResponse.serverVersion) && Objects.equals(this.startTime, statusResponse.startTime) && Objects.equals(this.vip, statusResponse.vip);
    }

    public int hashCode() {
        return Objects.hash(this.players, this.serverVersion, this.startTime, this.vip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StatusResponse {\n");
        sb.append("    players: ").append(this.toIndentedString(this.players)).append("\n");
        sb.append("    serverVersion: ").append(this.toIndentedString(this.serverVersion)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    vip: ").append(this.toIndentedString(this.vip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

