/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 1.11
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationAssetsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_IS_BLUEPRINT_COPY = "is_blueprint_copy";
    @SerializedName(SERIALIZED_NAME_IS_BLUEPRINT_COPY)
    private Boolean isBlueprintCopy;

    public static final String SERIALIZED_NAME_IS_SINGLETON = "is_singleton";
    @SerializedName(SERIALIZED_NAME_IS_SINGLETON)
    private Boolean isSingleton;

    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(SERIALIZED_NAME_ITEM_ID)
    private Long itemId;

    /**
     * location_flag string
     */
    @JsonAdapter(LocationFlagEnum.Adapter.class)
    public enum LocationFlagEnum {
        ASSETSAFETY("AssetSafety"),

        AUTOFIT("AutoFit"),

        BONUS("Bonus"),

        BOOSTER("Booster"),

        BOOSTERBAY("BoosterBay"),

        CAPSULE("Capsule"),

        CARGO("Cargo"),

        CORPDELIVERIES("CorpDeliveries"),

        CORPSAG1("CorpSAG1"),

        CORPSAG2("CorpSAG2"),

        CORPSAG3("CorpSAG3"),

        CORPSAG4("CorpSAG4"),

        CORPSAG5("CorpSAG5"),

        CORPSAG6("CorpSAG6"),

        CORPSAG7("CorpSAG7"),

        CRATELOOT("CrateLoot"),

        DELIVERIES("Deliveries"),

        DRONEBAY("DroneBay"),

        DUSTBATTLE("DustBattle"),

        DUSTDATABANK("DustDatabank"),

        FIGHTERBAY("FighterBay"),

        FIGHTERTUBE0("FighterTube0"),

        FIGHTERTUBE1("FighterTube1"),

        FIGHTERTUBE2("FighterTube2"),

        FIGHTERTUBE3("FighterTube3"),

        FIGHTERTUBE4("FighterTube4"),

        FLEETHANGAR("FleetHangar"),

        FRIGATEESCAPEBAY("FrigateEscapeBay"),

        HANGAR("Hangar"),

        HANGARALL("HangarAll"),

        HISLOT0("HiSlot0"),

        HISLOT1("HiSlot1"),

        HISLOT2("HiSlot2"),

        HISLOT3("HiSlot3"),

        HISLOT4("HiSlot4"),

        HISLOT5("HiSlot5"),

        HISLOT6("HiSlot6"),

        HISLOT7("HiSlot7"),

        HIDDENMODIFIERS("HiddenModifiers"),

        IMPLANT("Implant"),

        IMPOUNDED("Impounded"),

        JUNKYARDREPROCESSED("JunkyardReprocessed"),

        JUNKYARDTRASHED("JunkyardTrashed"),

        LOSLOT0("LoSlot0"),

        LOSLOT1("LoSlot1"),

        LOSLOT2("LoSlot2"),

        LOSLOT3("LoSlot3"),

        LOSLOT4("LoSlot4"),

        LOSLOT5("LoSlot5"),

        LOSLOT6("LoSlot6"),

        LOSLOT7("LoSlot7"),

        LOCKED("Locked"),

        MEDSLOT0("MedSlot0"),

        MEDSLOT1("MedSlot1"),

        MEDSLOT2("MedSlot2"),

        MEDSLOT3("MedSlot3"),

        MEDSLOT4("MedSlot4"),

        MEDSLOT5("MedSlot5"),

        MEDSLOT6("MedSlot6"),

        MEDSLOT7("MedSlot7"),

        OFFICEFOLDER("OfficeFolder"),

        PILOT("Pilot"),

        PLANETSURFACE("PlanetSurface"),

        QUAFEBAY("QuafeBay"),

        QUANTUMCOREROOM("QuantumCoreRoom"),

        REWARD("Reward"),

        RIGSLOT0("RigSlot0"),

        RIGSLOT1("RigSlot1"),

        RIGSLOT2("RigSlot2"),

        RIGSLOT3("RigSlot3"),

        RIGSLOT4("RigSlot4"),

        RIGSLOT5("RigSlot5"),

        RIGSLOT6("RigSlot6"),

        RIGSLOT7("RigSlot7"),

        SECONDARYSTORAGE("SecondaryStorage"),

        SERVICESLOT0("ServiceSlot0"),

        SERVICESLOT1("ServiceSlot1"),

        SERVICESLOT2("ServiceSlot2"),

        SERVICESLOT3("ServiceSlot3"),

        SERVICESLOT4("ServiceSlot4"),

        SERVICESLOT5("ServiceSlot5"),

        SERVICESLOT6("ServiceSlot6"),

        SERVICESLOT7("ServiceSlot7"),

        SHIPHANGAR("ShipHangar"),

        SHIPOFFLINE("ShipOffline"),

        SKILL("Skill"),

        SKILLINTRAINING("SkillInTraining"),

        SPECIALIZEDAMMOHOLD("SpecializedAmmoHold"),

        SPECIALIZEDASTEROIDHOLD("SpecializedAsteroidHold"),

        SPECIALIZEDCOMMANDCENTERHOLD("SpecializedCommandCenterHold"),

        SPECIALIZEDFUELBAY("SpecializedFuelBay"),

        SPECIALIZEDGASHOLD("SpecializedGasHold"),

        SPECIALIZEDICEHOLD("SpecializedIceHold"),

        SPECIALIZEDINDUSTRIALSHIPHOLD("SpecializedIndustrialShipHold"),

        SPECIALIZEDLARGESHIPHOLD("SpecializedLargeShipHold"),

        SPECIALIZEDMATERIALBAY("SpecializedMaterialBay"),

        SPECIALIZEDMEDIUMSHIPHOLD("SpecializedMediumShipHold"),

        SPECIALIZEDMINERALHOLD("SpecializedMineralHold"),

        SPECIALIZEDOREHOLD("SpecializedOreHold"),

        SPECIALIZEDPLANETARYCOMMODITIESHOLD("SpecializedPlanetaryCommoditiesHold"),

        SPECIALIZEDSALVAGEHOLD("SpecializedSalvageHold"),

        SPECIALIZEDSHIPHOLD("SpecializedShipHold"),

        SPECIALIZEDSMALLSHIPHOLD("SpecializedSmallShipHold"),

        STRUCTUREACTIVE("StructureActive"),

        STRUCTUREFUEL("StructureFuel"),

        STRUCTUREINACTIVE("StructureInactive"),

        STRUCTUREOFFLINE("StructureOffline"),

        SUBSYSTEMBAY("SubSystemBay"),

        SUBSYSTEMSLOT0("SubSystemSlot0"),

        SUBSYSTEMSLOT1("SubSystemSlot1"),

        SUBSYSTEMSLOT2("SubSystemSlot2"),

        SUBSYSTEMSLOT3("SubSystemSlot3"),

        SUBSYSTEMSLOT4("SubSystemSlot4"),

        SUBSYSTEMSLOT5("SubSystemSlot5"),

        SUBSYSTEMSLOT6("SubSystemSlot6"),

        SUBSYSTEMSLOT7("SubSystemSlot7"),

        UNLOCKED("Unlocked"),

        WALLET("Wallet"),

        WARDROBE("Wardrobe");

        private String value;

        LocationFlagEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static LocationFlagEnum fromValue(String value) {
            for (LocationFlagEnum b : LocationFlagEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return null;
        }

        public static class Adapter extends TypeAdapter<LocationFlagEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final LocationFlagEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public LocationFlagEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocationFlagEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_LOCATION_FLAG = "location_flag";
    @SerializedName(SERIALIZED_NAME_LOCATION_FLAG)
    private String locationFlag;
    private LocationFlagEnum locationFlagEnum;

    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(SERIALIZED_NAME_LOCATION_ID)
    private Long locationId;

    /**
     * location_type string
     */
    @JsonAdapter(LocationTypeEnum.Adapter.class)
    public enum LocationTypeEnum {
        STATION("station"),

        SOLAR_SYSTEM("solar_system"),

        ITEM("item"),

        OTHER("other");

        private String value;

        LocationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static LocationTypeEnum fromValue(String value) {
            for (LocationTypeEnum b : LocationTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return null;
        }

        public static class Adapter extends TypeAdapter<LocationTypeEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final LocationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public LocationTypeEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocationTypeEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_LOCATION_TYPE = "location_type";
    @SerializedName(SERIALIZED_NAME_LOCATION_TYPE)
    private String locationType;
    private LocationTypeEnum locationTypeEnum;

    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(SERIALIZED_NAME_QUANTITY)
    private Integer quantity;

    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(SERIALIZED_NAME_TYPE_ID)
    private Integer typeId;

    public CorporationAssetsResponse isBlueprintCopy(Boolean isBlueprintCopy) {

        this.isBlueprintCopy = isBlueprintCopy;
        return this;
    }

    /**
     * is_blueprint_copy boolean
     * 
     * @return isBlueprintCopy
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "is_blueprint_copy boolean")
    public Boolean getIsBlueprintCopy() {
        return isBlueprintCopy;
    }

    public void setIsBlueprintCopy(Boolean isBlueprintCopy) {
        this.isBlueprintCopy = isBlueprintCopy;
    }

    public CorporationAssetsResponse isSingleton(Boolean isSingleton) {

        this.isSingleton = isSingleton;
        return this;
    }

    /**
     * is_singleton boolean
     * 
     * @return isSingleton
     **/
    @ApiModelProperty(required = true, value = "is_singleton boolean")
    public Boolean getIsSingleton() {
        return isSingleton;
    }

    public void setIsSingleton(Boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    public CorporationAssetsResponse itemId(Long itemId) {

        this.itemId = itemId;
        return this;
    }

    /**
     * item_id integer
     * 
     * @return itemId
     **/
    @ApiModelProperty(required = true, value = "item_id integer")
    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public CorporationAssetsResponse locationFlag(LocationFlagEnum locationFlagEnum) {

        this.locationFlagEnum = locationFlagEnum;
        return this;
    }

    public CorporationAssetsResponse locationFlagString(String locationFlag) {

        this.locationFlag = locationFlag;
        return this;
    }

    /**
     * location_flag string
     * 
     * @return locationFlag
     **/
    @ApiModelProperty(required = true, value = "location_flag string")
    public LocationFlagEnum getLocationFlag() {
        if (locationFlagEnum == null) {
            locationFlagEnum = LocationFlagEnum.fromValue(locationFlag);
        }
        return locationFlagEnum;
    }

    public String getLocationFlagString() {
        return locationFlag;
    }

    public void setLocationFlag(LocationFlagEnum locationFlagEnum) {
        this.locationFlagEnum = locationFlagEnum;
    }

    public void setLocationFlagString(String locationFlag) {
        this.locationFlag = locationFlag;
    }

    public CorporationAssetsResponse locationId(Long locationId) {

        this.locationId = locationId;
        return this;
    }

    /**
     * location_id integer
     * 
     * @return locationId
     **/
    @ApiModelProperty(required = true, value = "location_id integer")
    public Long getLocationId() {
        return locationId;
    }

    public void setLocationId(Long locationId) {
        this.locationId = locationId;
    }

    public CorporationAssetsResponse locationType(LocationTypeEnum locationTypeEnum) {

        this.locationTypeEnum = locationTypeEnum;
        return this;
    }

    public CorporationAssetsResponse locationTypeString(String locationType) {

        this.locationType = locationType;
        return this;
    }

    /**
     * location_type string
     * 
     * @return locationType
     **/
    @ApiModelProperty(required = true, value = "location_type string")
    public LocationTypeEnum getLocationType() {
        if (locationTypeEnum == null) {
            locationTypeEnum = LocationTypeEnum.fromValue(locationType);
        }
        return locationTypeEnum;
    }

    public String getLocationTypeString() {
        return locationType;
    }

    public void setLocationType(LocationTypeEnum locationTypeEnum) {
        this.locationTypeEnum = locationTypeEnum;
    }

    public void setLocationTypeString(String locationType) {
        this.locationType = locationType;
    }

    public CorporationAssetsResponse quantity(Integer quantity) {

        this.quantity = quantity;
        return this;
    }

    /**
     * quantity integer
     * 
     * @return quantity
     **/
    @ApiModelProperty(required = true, value = "quantity integer")
    public Integer getQuantity() {
        return quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public CorporationAssetsResponse typeId(Integer typeId) {

        this.typeId = typeId;
        return this;
    }

    /**
     * type_id integer
     * 
     * @return typeId
     **/
    @ApiModelProperty(required = true, value = "type_id integer")
    public Integer getTypeId() {
        return typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationAssetsResponse corporationAssetsResponse = (CorporationAssetsResponse) o;
        return Objects.equals(this.isBlueprintCopy, corporationAssetsResponse.isBlueprintCopy)
                && Objects.equals(this.isSingleton, corporationAssetsResponse.isSingleton)
                && Objects.equals(this.itemId, corporationAssetsResponse.itemId)
                && Objects.equals(this.locationFlag, corporationAssetsResponse.locationFlag)
                && Objects.equals(this.locationId, corporationAssetsResponse.locationId)
                && Objects.equals(this.locationType, corporationAssetsResponse.locationType)
                && Objects.equals(this.quantity, corporationAssetsResponse.quantity)
                && Objects.equals(this.typeId, corporationAssetsResponse.typeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(isBlueprintCopy, isSingleton, itemId, locationFlag, locationId, locationType, quantity,
                typeId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationAssetsResponse {\n");
        sb.append("    isBlueprintCopy: ").append(toIndentedString(isBlueprintCopy)).append("\n");
        sb.append("    isSingleton: ").append(toIndentedString(isSingleton)).append("\n");
        sb.append("    itemId: ").append(toIndentedString(itemId)).append("\n");
        sb.append("    locationFlag: ").append(toIndentedString(locationFlag)).append("\n");
        sb.append("    locationId: ").append(toIndentedString(locationId)).append("\n");
        sb.append("    locationType: ").append(toIndentedString(locationType)).append("\n");
        sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
        sb.append("    typeId: ").append(toIndentedString(typeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
