/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.Aggressor;
import net.troja.eve.esi.model.Defender;
import net.troja.eve.esi.model.WarAlly;

@ApiModel(description="200 ok object")
public class WarResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_AGGRESSOR = "aggressor";
    @SerializedName(value="aggressor")
    private Aggressor aggressor;
    public static final String SERIALIZED_NAME_ALLIES = "allies";
    @SerializedName(value="allies")
    private List<WarAlly> allies = null;
    public static final String SERIALIZED_NAME_DECLARED = "declared";
    @SerializedName(value="declared")
    private OffsetDateTime declared;
    public static final String SERIALIZED_NAME_DEFENDER = "defender";
    @SerializedName(value="defender")
    private Defender defender;
    public static final String SERIALIZED_NAME_FINISHED = "finished";
    @SerializedName(value="finished")
    private OffsetDateTime finished;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_MUTUAL = "mutual";
    @SerializedName(value="mutual")
    private Boolean mutual;
    public static final String SERIALIZED_NAME_OPEN_FOR_ALLIES = "open_for_allies";
    @SerializedName(value="open_for_allies")
    private Boolean openForAllies;
    public static final String SERIALIZED_NAME_RETRACTED = "retracted";
    @SerializedName(value="retracted")
    private OffsetDateTime retracted;
    public static final String SERIALIZED_NAME_STARTED = "started";
    @SerializedName(value="started")
    private OffsetDateTime started;

    public WarResponse aggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Aggressor getAggressor() {
        return this.aggressor;
    }

    public void setAggressor(Aggressor aggressor) {
        this.aggressor = aggressor;
    }

    public WarResponse allies(List<WarAlly> allies) {
        this.allies = allies;
        return this;
    }

    public WarResponse addAlliesItem(WarAlly alliesItem) {
        if (this.allies == null) {
            this.allies = new ArrayList<WarAlly>();
        }
        this.allies.add(alliesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allied corporations or alliances, each object contains either corporation_id or alliance_id")
    public List<WarAlly> getAllies() {
        return this.allies;
    }

    public void setAllies(List<WarAlly> allies) {
        this.allies = allies;
    }

    public WarResponse declared(OffsetDateTime declared) {
        this.declared = declared;
        return this;
    }

    @ApiModelProperty(required=true, value="Time that the war was declared")
    public OffsetDateTime getDeclared() {
        return this.declared;
    }

    public void setDeclared(OffsetDateTime declared) {
        this.declared = declared;
    }

    public WarResponse defender(Defender defender) {
        this.defender = defender;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Defender getDefender() {
        return this.defender;
    }

    public void setDefender(Defender defender) {
        this.defender = defender;
    }

    public WarResponse finished(OffsetDateTime finished) {
        this.finished = finished;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time the war ended and shooting was no longer allowed")
    public OffsetDateTime getFinished() {
        return this.finished;
    }

    public void setFinished(OffsetDateTime finished) {
        this.finished = finished;
    }

    public WarResponse id(Integer id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="ID of the specified war")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public WarResponse mutual(Boolean mutual) {
        this.mutual = mutual;
        return this;
    }

    @ApiModelProperty(required=true, value="Was the war declared mutual by both parties")
    public Boolean getMutual() {
        return this.mutual;
    }

    public void setMutual(Boolean mutual) {
        this.mutual = mutual;
    }

    public WarResponse openForAllies(Boolean openForAllies) {
        this.openForAllies = openForAllies;
        return this;
    }

    @ApiModelProperty(required=true, value="Is the war currently open for allies or not")
    public Boolean getOpenForAllies() {
        return this.openForAllies;
    }

    public void setOpenForAllies(Boolean openForAllies) {
        this.openForAllies = openForAllies;
    }

    public WarResponse retracted(OffsetDateTime retracted) {
        this.retracted = retracted;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time the war was retracted but both sides could still shoot each other")
    public OffsetDateTime getRetracted() {
        return this.retracted;
    }

    public void setRetracted(OffsetDateTime retracted) {
        this.retracted = retracted;
    }

    public WarResponse started(OffsetDateTime started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time when the war started and both sides could shoot each other")
    public OffsetDateTime getStarted() {
        return this.started;
    }

    public void setStarted(OffsetDateTime started) {
        this.started = started;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarResponse warResponse = (WarResponse)o;
        return Objects.equals(this.aggressor, warResponse.aggressor) && Objects.equals(this.allies, warResponse.allies) && Objects.equals(this.declared, warResponse.declared) && Objects.equals(this.defender, warResponse.defender) && Objects.equals(this.finished, warResponse.finished) && Objects.equals(this.id, warResponse.id) && Objects.equals(this.mutual, warResponse.mutual) && Objects.equals(this.openForAllies, warResponse.openForAllies) && Objects.equals(this.retracted, warResponse.retracted) && Objects.equals(this.started, warResponse.started);
    }

    public int hashCode() {
        return Objects.hash(this.aggressor, this.allies, this.declared, this.defender, this.finished, this.id, this.mutual, this.openForAllies, this.retracted, this.started);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WarResponse {\n");
        sb.append("    aggressor: ").append(this.toIndentedString(this.aggressor)).append("\n");
        sb.append("    allies: ").append(this.toIndentedString(this.allies)).append("\n");
        sb.append("    declared: ").append(this.toIndentedString(this.declared)).append("\n");
        sb.append("    defender: ").append(this.toIndentedString(this.defender)).append("\n");
        sb.append("    finished: ").append(this.toIndentedString(this.finished)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mutual: ").append(this.toIndentedString(this.mutual)).append("\n");
        sb.append("    openForAllies: ").append(this.toIndentedString(this.openForAllies)).append("\n");
        sb.append("    retracted: ").append(this.toIndentedString(this.retracted)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

