/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterAffiliationResponse;
import net.troja.eve.esi.model.CharacterBlueprintsResponse;
import net.troja.eve.esi.model.CharacterCorporationHistoryResponse;
import net.troja.eve.esi.model.CharacterFatigueResponse;
import net.troja.eve.esi.model.CharacterMedalsResponse;
import net.troja.eve.esi.model.CharacterNotificationsResponse;
import net.troja.eve.esi.model.CharacterPortraitResponse;
import net.troja.eve.esi.model.CharacterResearchAgentsResponse;
import net.troja.eve.esi.model.CharacterResponse;
import net.troja.eve.esi.model.CharacterRolesResponse;
import net.troja.eve.esi.model.CharacterStandingsResponse;
import net.troja.eve.esi.model.CharacterTitlesResponse;
import net.troja.eve.esi.model.NewContactNotificationsResponse;
import okhttp3.Call;

public class CharacterApi {
    private ApiClient localVarApiClient;

    public CharacterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CharacterApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCharactersCharacterIdCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v5/characters/{character_id}/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterId(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdCall(characterId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public CharacterResponse getCharactersCharacterId(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<CharacterResponse> localVarResp = this.getCharactersCharacterIdWithHttpInfo(characterId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterResponse> getCharactersCharacterIdWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdValidateBeforeCall(characterId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CharacterResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdAsync(Integer characterId, String datasource, String ifNoneMatch, ApiCallback<CharacterResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdValidateBeforeCall(characterId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CharacterResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdAgentsResearchCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/agents_research/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdAgentsResearchValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdAgentsResearch(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdAgentsResearchCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterResearchAgentsResponse> getCharactersCharacterIdAgentsResearch(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterResearchAgentsResponse>> localVarResp = this.getCharactersCharacterIdAgentsResearchWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterResearchAgentsResponse>> getCharactersCharacterIdAgentsResearchWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdAgentsResearchValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterResearchAgentsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdAgentsResearchAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterResearchAgentsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdAgentsResearchValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterResearchAgentsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdBlueprintsCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/blueprints/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdBlueprintsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdBlueprints(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdBlueprintsCall(characterId, datasource, ifNoneMatch, page, token, _callback);
        return localVarCall;
    }

    public List<CharacterBlueprintsResponse> getCharactersCharacterIdBlueprints(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        ApiResponse<List<CharacterBlueprintsResponse>> localVarResp = this.getCharactersCharacterIdBlueprintsWithHttpInfo(characterId, datasource, ifNoneMatch, page, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterBlueprintsResponse>> getCharactersCharacterIdBlueprintsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdBlueprintsValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterBlueprintsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdBlueprintsAsync(Integer characterId, String datasource, String ifNoneMatch, Integer page, String token, ApiCallback<List<CharacterBlueprintsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdBlueprintsValidateBeforeCall(characterId, datasource, ifNoneMatch, page, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterBlueprintsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdCorporationhistoryCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/corporationhistory/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdCorporationhistoryValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdCorporationhistory(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdCorporationhistoryCall(characterId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public List<CharacterCorporationHistoryResponse> getCharactersCharacterIdCorporationhistory(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<List<CharacterCorporationHistoryResponse>> localVarResp = this.getCharactersCharacterIdCorporationhistoryWithHttpInfo(characterId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterCorporationHistoryResponse>> getCharactersCharacterIdCorporationhistoryWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdCorporationhistoryValidateBeforeCall(characterId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<List<CharacterCorporationHistoryResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdCorporationhistoryAsync(Integer characterId, String datasource, String ifNoneMatch, ApiCallback<List<CharacterCorporationHistoryResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdCorporationhistoryValidateBeforeCall(characterId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterCorporationHistoryResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdFatigueCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/fatigue/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdFatigueValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdFatigue(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdFatigueCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public CharacterFatigueResponse getCharactersCharacterIdFatigue(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterFatigueResponse> localVarResp = this.getCharactersCharacterIdFatigueWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterFatigueResponse> getCharactersCharacterIdFatigueWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdFatigueValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterFatigueResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdFatigueAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<CharacterFatigueResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdFatigueValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterFatigueResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdMedalsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/medals/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdMedalsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdMedals(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdMedalsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterMedalsResponse> getCharactersCharacterIdMedals(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterMedalsResponse>> localVarResp = this.getCharactersCharacterIdMedalsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterMedalsResponse>> getCharactersCharacterIdMedalsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdMedalsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterMedalsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdMedalsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterMedalsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdMedalsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterMedalsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdNotificationsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v5/characters/{character_id}/notifications/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdNotificationsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdNotifications(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdNotificationsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterNotificationsResponse> getCharactersCharacterIdNotifications(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterNotificationsResponse>> localVarResp = this.getCharactersCharacterIdNotificationsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterNotificationsResponse>> getCharactersCharacterIdNotificationsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdNotificationsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterNotificationsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdNotificationsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterNotificationsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdNotificationsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterNotificationsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdNotificationsContactsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/notifications/contacts/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdNotificationsContactsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdNotificationsContacts(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdNotificationsContactsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<NewContactNotificationsResponse> getCharactersCharacterIdNotificationsContacts(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<NewContactNotificationsResponse>> localVarResp = this.getCharactersCharacterIdNotificationsContactsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<NewContactNotificationsResponse>> getCharactersCharacterIdNotificationsContactsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdNotificationsContactsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<NewContactNotificationsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdNotificationsContactsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<NewContactNotificationsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdNotificationsContactsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<NewContactNotificationsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdPortraitCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/portrait/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdPortraitValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdPortrait(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdPortraitCall(characterId, datasource, ifNoneMatch, _callback);
        return localVarCall;
    }

    public CharacterPortraitResponse getCharactersCharacterIdPortrait(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        ApiResponse<CharacterPortraitResponse> localVarResp = this.getCharactersCharacterIdPortraitWithHttpInfo(characterId, datasource, ifNoneMatch);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterPortraitResponse> getCharactersCharacterIdPortraitWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPortraitValidateBeforeCall(characterId, datasource, ifNoneMatch, null);
        Type localVarReturnType = new TypeToken<CharacterPortraitResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdPortraitAsync(Integer characterId, String datasource, String ifNoneMatch, ApiCallback<CharacterPortraitResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdPortraitValidateBeforeCall(characterId, datasource, ifNoneMatch, _callback);
        Type localVarReturnType = new TypeToken<CharacterPortraitResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdRolesCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/roles/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdRolesValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdRoles(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdRolesCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public CharacterRolesResponse getCharactersCharacterIdRoles(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<CharacterRolesResponse> localVarResp = this.getCharactersCharacterIdRolesWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterRolesResponse> getCharactersCharacterIdRolesWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdRolesValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<CharacterRolesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdRolesAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<CharacterRolesResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdRolesValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterRolesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdStandingsCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/standings/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdStandingsValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdStandings(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdStandingsCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterStandingsResponse> getCharactersCharacterIdStandings(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterStandingsResponse>> localVarResp = this.getCharactersCharacterIdStandingsWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterStandingsResponse>> getCharactersCharacterIdStandingsWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdStandingsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterStandingsResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdStandingsAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterStandingsResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdStandingsValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterStandingsResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCharactersCharacterIdTitlesCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/characters/{character_id}/titles/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdTitlesValidateBeforeCall(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdTitles(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdTitlesCall(characterId, datasource, ifNoneMatch, token, _callback);
        return localVarCall;
    }

    public List<CharacterTitlesResponse> getCharactersCharacterIdTitles(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        ApiResponse<List<CharacterTitlesResponse>> localVarResp = this.getCharactersCharacterIdTitlesWithHttpInfo(characterId, datasource, ifNoneMatch, token);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterTitlesResponse>> getCharactersCharacterIdTitlesWithHttpInfo(Integer characterId, String datasource, String ifNoneMatch, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdTitlesValidateBeforeCall(characterId, datasource, ifNoneMatch, token, null);
        Type localVarReturnType = new TypeToken<List<CharacterTitlesResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdTitlesAsync(Integer characterId, String datasource, String ifNoneMatch, String token, ApiCallback<List<CharacterTitlesResponse>> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdTitlesValidateBeforeCall(characterId, datasource, ifNoneMatch, token, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterTitlesResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postCharactersAffiliationCall(List<Integer> characters, String datasource, ApiCallback _callback) throws ApiException {
        List<Integer> localVarPostBody = characters;
        String localVarPath = "/v2/characters/affiliation/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCharactersAffiliationValidateBeforeCall(List<Integer> characters, String datasource, ApiCallback _callback) throws ApiException {
        if (characters == null) {
            throw new ApiException("Missing the required parameter 'characters' when calling postCharactersAffiliation(Async)");
        }
        Call localVarCall = this.postCharactersAffiliationCall(characters, datasource, _callback);
        return localVarCall;
    }

    public List<CharacterAffiliationResponse> postCharactersAffiliation(List<Integer> characters, String datasource) throws ApiException {
        ApiResponse<List<CharacterAffiliationResponse>> localVarResp = this.postCharactersAffiliationWithHttpInfo(characters, datasource);
        return localVarResp.getData();
    }

    public ApiResponse<List<CharacterAffiliationResponse>> postCharactersAffiliationWithHttpInfo(List<Integer> characters, String datasource) throws ApiException {
        Call localVarCall = this.postCharactersAffiliationValidateBeforeCall(characters, datasource, null);
        Type localVarReturnType = new TypeToken<List<CharacterAffiliationResponse>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postCharactersAffiliationAsync(List<Integer> characters, String datasource, ApiCallback<List<CharacterAffiliationResponse>> _callback) throws ApiException {
        Call localVarCall = this.postCharactersAffiliationValidateBeforeCall(characters, datasource, _callback);
        Type localVarReturnType = new TypeToken<List<CharacterAffiliationResponse>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postCharactersCharacterIdCspaCall(Integer characterId, List<Integer> characters, String datasource, String token, ApiCallback _callback) throws ApiException {
        List<Integer> localVarPostBody = characters;
        String localVarPath = "/v5/characters/{character_id}/cspa/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postCharactersCharacterIdCspaValidateBeforeCall(Integer characterId, List<Integer> characters, String datasource, String token, ApiCallback _callback) throws ApiException {
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling postCharactersCharacterIdCspa(Async)");
        }
        if (characters == null) {
            throw new ApiException("Missing the required parameter 'characters' when calling postCharactersCharacterIdCspa(Async)");
        }
        Call localVarCall = this.postCharactersCharacterIdCspaCall(characterId, characters, datasource, token, _callback);
        return localVarCall;
    }

    public Float postCharactersCharacterIdCspa(Integer characterId, List<Integer> characters, String datasource, String token) throws ApiException {
        ApiResponse<Float> localVarResp = this.postCharactersCharacterIdCspaWithHttpInfo(characterId, characters, datasource, token);
        return localVarResp.getData();
    }

    public ApiResponse<Float> postCharactersCharacterIdCspaWithHttpInfo(Integer characterId, List<Integer> characters, String datasource, String token) throws ApiException {
        Call localVarCall = this.postCharactersCharacterIdCspaValidateBeforeCall(characterId, characters, datasource, token, null);
        Type localVarReturnType = new TypeToken<Float>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postCharactersCharacterIdCspaAsync(Integer characterId, List<Integer> characters, String datasource, String token, ApiCallback<Float> _callback) throws ApiException {
        Call localVarCall = this.postCharactersCharacterIdCspaValidateBeforeCall(characterId, characters, datasource, token, _callback);
        Type localVarReturnType = new TypeToken<Float>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

