/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.KillmailItem;
import net.troja.eve.esi.model.Position;

@ApiModel(description="victim object")
public class KillmailVictim
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLIANCE_ID = "alliance_id";
    @SerializedName(value="alliance_id")
    private Integer allianceId;
    public static final String SERIALIZED_NAME_CHARACTER_ID = "character_id";
    @SerializedName(value="character_id")
    private Integer characterId;
    public static final String SERIALIZED_NAME_CORPORATION_ID = "corporation_id";
    @SerializedName(value="corporation_id")
    private Integer corporationId;
    public static final String SERIALIZED_NAME_DAMAGE_TAKEN = "damage_taken";
    @SerializedName(value="damage_taken")
    private Integer damageTaken;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    private Integer factionId;
    public static final String SERIALIZED_NAME_ITEMS = "items";
    @SerializedName(value="items")
    private List<KillmailItem> items = null;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    private Position position;
    public static final String SERIALIZED_NAME_SHIP_TYPE_ID = "ship_type_id";
    @SerializedName(value="ship_type_id")
    private Integer shipTypeId;

    public KillmailVictim allianceId(Integer allianceId) {
        this.allianceId = allianceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="alliance_id integer")
    public Integer getAllianceId() {
        return this.allianceId;
    }

    public void setAllianceId(Integer allianceId) {
        this.allianceId = allianceId;
    }

    public KillmailVictim characterId(Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="character_id integer")
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(Integer characterId) {
        this.characterId = characterId;
    }

    public KillmailVictim corporationId(Integer corporationId) {
        this.corporationId = corporationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="corporation_id integer")
    public Integer getCorporationId() {
        return this.corporationId;
    }

    public void setCorporationId(Integer corporationId) {
        this.corporationId = corporationId;
    }

    public KillmailVictim damageTaken(Integer damageTaken) {
        this.damageTaken = damageTaken;
        return this;
    }

    @ApiModelProperty(required=true, value="How much total damage was taken by the victim ")
    public Integer getDamageTaken() {
        return this.damageTaken;
    }

    public void setDamageTaken(Integer damageTaken) {
        this.damageTaken = damageTaken;
    }

    public KillmailVictim factionId(Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="faction_id integer")
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(Integer factionId) {
        this.factionId = factionId;
    }

    public KillmailVictim items(List<KillmailItem> items) {
        this.items = items;
        return this;
    }

    public KillmailVictim addItemsItem(KillmailItem itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<KillmailItem>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="items array")
    public List<KillmailItem> getItems() {
        return this.items;
    }

    public void setItems(List<KillmailItem> items) {
        this.items = items;
    }

    public KillmailVictim position(Position position) {
        this.position = position;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public KillmailVictim shipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ship that the victim was piloting and was destroyed ")
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KillmailVictim killmailVictim = (KillmailVictim)o;
        return Objects.equals(this.allianceId, killmailVictim.allianceId) && Objects.equals(this.characterId, killmailVictim.characterId) && Objects.equals(this.corporationId, killmailVictim.corporationId) && Objects.equals(this.damageTaken, killmailVictim.damageTaken) && Objects.equals(this.factionId, killmailVictim.factionId) && Objects.equals(this.items, killmailVictim.items) && Objects.equals(this.position, killmailVictim.position) && Objects.equals(this.shipTypeId, killmailVictim.shipTypeId);
    }

    public int hashCode() {
        return Objects.hash(this.allianceId, this.characterId, this.corporationId, this.damageTaken, this.factionId, this.items, this.position, this.shipTypeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KillmailVictim {\n");
        sb.append("    allianceId: ").append(this.toIndentedString(this.allianceId)).append("\n");
        sb.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        sb.append("    corporationId: ").append(this.toIndentedString(this.corporationId)).append("\n");
        sb.append("    damageTaken: ").append(this.toIndentedString(this.damageTaken)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

