/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.troja.eve.esi.model.CorporationStarbaseFuel;

@ApiModel(description="200 ok object")
public class CorporationStarbaseResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ALLOW_ALLIANCE_MEMBERS = "allow_alliance_members";
    @SerializedName(value="allow_alliance_members")
    private Boolean allowAllianceMembers;
    public static final String SERIALIZED_NAME_ALLOW_CORPORATION_MEMBERS = "allow_corporation_members";
    @SerializedName(value="allow_corporation_members")
    private Boolean allowCorporationMembers;
    public static final String SERIALIZED_NAME_ANCHOR = "anchor";
    @SerializedName(value="anchor")
    private String anchor;
    private AnchorEnum anchorEnum;
    public static final String SERIALIZED_NAME_ATTACK_IF_AT_WAR = "attack_if_at_war";
    @SerializedName(value="attack_if_at_war")
    private Boolean attackIfAtWar;
    public static final String SERIALIZED_NAME_ATTACK_IF_OTHER_SECURITY_STATUS_DROPPING = "attack_if_other_security_status_dropping";
    @SerializedName(value="attack_if_other_security_status_dropping")
    private Boolean attackIfOtherSecurityStatusDropping;
    public static final String SERIALIZED_NAME_ATTACK_SECURITY_STATUS_THRESHOLD = "attack_security_status_threshold";
    @SerializedName(value="attack_security_status_threshold")
    private Float attackSecurityStatusThreshold;
    public static final String SERIALIZED_NAME_ATTACK_STANDING_THRESHOLD = "attack_standing_threshold";
    @SerializedName(value="attack_standing_threshold")
    private Float attackStandingThreshold;
    public static final String SERIALIZED_NAME_FUEL_BAY_TAKE = "fuel_bay_take";
    @SerializedName(value="fuel_bay_take")
    private String fuelBayTake;
    private FuelBayTakeEnum fuelBayTakeEnum;
    public static final String SERIALIZED_NAME_FUEL_BAY_VIEW = "fuel_bay_view";
    @SerializedName(value="fuel_bay_view")
    private String fuelBayView;
    private FuelBayViewEnum fuelBayViewEnum;
    public static final String SERIALIZED_NAME_FUELS = "fuels";
    @SerializedName(value="fuels")
    private List<CorporationStarbaseFuel> fuels = null;
    public static final String SERIALIZED_NAME_OFFLINE = "offline";
    @SerializedName(value="offline")
    private String offline;
    private OfflineEnum offlineEnum;
    public static final String SERIALIZED_NAME_ONLINE = "online";
    @SerializedName(value="online")
    private String online;
    private OnlineEnum onlineEnum;
    public static final String SERIALIZED_NAME_UNANCHOR = "unanchor";
    @SerializedName(value="unanchor")
    private String unanchor;
    private UnanchorEnum unanchorEnum;
    public static final String SERIALIZED_NAME_USE_ALLIANCE_STANDINGS = "use_alliance_standings";
    @SerializedName(value="use_alliance_standings")
    private Boolean useAllianceStandings;

    public CorporationStarbaseResponse allowAllianceMembers(Boolean allowAllianceMembers) {
        this.allowAllianceMembers = allowAllianceMembers;
        return this;
    }

    @ApiModelProperty(required=true, value="allow_alliance_members boolean")
    public Boolean getAllowAllianceMembers() {
        return this.allowAllianceMembers;
    }

    public void setAllowAllianceMembers(Boolean allowAllianceMembers) {
        this.allowAllianceMembers = allowAllianceMembers;
    }

    public CorporationStarbaseResponse allowCorporationMembers(Boolean allowCorporationMembers) {
        this.allowCorporationMembers = allowCorporationMembers;
        return this;
    }

    @ApiModelProperty(required=true, value="allow_corporation_members boolean")
    public Boolean getAllowCorporationMembers() {
        return this.allowCorporationMembers;
    }

    public void setAllowCorporationMembers(Boolean allowCorporationMembers) {
        this.allowCorporationMembers = allowCorporationMembers;
    }

    public CorporationStarbaseResponse anchor(AnchorEnum anchorEnum) {
        this.anchorEnum = anchorEnum;
        return this;
    }

    public CorporationStarbaseResponse anchorString(String anchor) {
        this.anchor = anchor;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can anchor starbase (POS) and its structures")
    public AnchorEnum getAnchor() {
        if (this.anchorEnum == null) {
            this.anchorEnum = AnchorEnum.fromValue(this.anchor);
        }
        return this.anchorEnum;
    }

    public String getAnchorString() {
        return this.anchor;
    }

    public void setAnchor(AnchorEnum anchorEnum) {
        this.anchorEnum = anchorEnum;
    }

    public void setAnchorString(String anchor) {
        this.anchor = anchor;
    }

    public CorporationStarbaseResponse attackIfAtWar(Boolean attackIfAtWar) {
        this.attackIfAtWar = attackIfAtWar;
        return this;
    }

    @ApiModelProperty(required=true, value="attack_if_at_war boolean")
    public Boolean getAttackIfAtWar() {
        return this.attackIfAtWar;
    }

    public void setAttackIfAtWar(Boolean attackIfAtWar) {
        this.attackIfAtWar = attackIfAtWar;
    }

    public CorporationStarbaseResponse attackIfOtherSecurityStatusDropping(Boolean attackIfOtherSecurityStatusDropping) {
        this.attackIfOtherSecurityStatusDropping = attackIfOtherSecurityStatusDropping;
        return this;
    }

    @ApiModelProperty(required=true, value="attack_if_other_security_status_dropping boolean")
    public Boolean getAttackIfOtherSecurityStatusDropping() {
        return this.attackIfOtherSecurityStatusDropping;
    }

    public void setAttackIfOtherSecurityStatusDropping(Boolean attackIfOtherSecurityStatusDropping) {
        this.attackIfOtherSecurityStatusDropping = attackIfOtherSecurityStatusDropping;
    }

    public CorporationStarbaseResponse attackSecurityStatusThreshold(Float attackSecurityStatusThreshold) {
        this.attackSecurityStatusThreshold = attackSecurityStatusThreshold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Starbase (POS) will attack if target's security standing is lower than this value")
    public Float getAttackSecurityStatusThreshold() {
        return this.attackSecurityStatusThreshold;
    }

    public void setAttackSecurityStatusThreshold(Float attackSecurityStatusThreshold) {
        this.attackSecurityStatusThreshold = attackSecurityStatusThreshold;
    }

    public CorporationStarbaseResponse attackStandingThreshold(Float attackStandingThreshold) {
        this.attackStandingThreshold = attackStandingThreshold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Starbase (POS) will attack if target's standing is lower than this value")
    public Float getAttackStandingThreshold() {
        return this.attackStandingThreshold;
    }

    public void setAttackStandingThreshold(Float attackStandingThreshold) {
        this.attackStandingThreshold = attackStandingThreshold;
    }

    public CorporationStarbaseResponse fuelBayTake(FuelBayTakeEnum fuelBayTakeEnum) {
        this.fuelBayTakeEnum = fuelBayTakeEnum;
        return this;
    }

    public CorporationStarbaseResponse fuelBayTakeString(String fuelBayTake) {
        this.fuelBayTake = fuelBayTake;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can take fuel blocks out of the starbase (POS)'s fuel bay")
    public FuelBayTakeEnum getFuelBayTake() {
        if (this.fuelBayTakeEnum == null) {
            this.fuelBayTakeEnum = FuelBayTakeEnum.fromValue(this.fuelBayTake);
        }
        return this.fuelBayTakeEnum;
    }

    public String getFuelBayTakeString() {
        return this.fuelBayTake;
    }

    public void setFuelBayTake(FuelBayTakeEnum fuelBayTakeEnum) {
        this.fuelBayTakeEnum = fuelBayTakeEnum;
    }

    public void setFuelBayTakeString(String fuelBayTake) {
        this.fuelBayTake = fuelBayTake;
    }

    public CorporationStarbaseResponse fuelBayView(FuelBayViewEnum fuelBayViewEnum) {
        this.fuelBayViewEnum = fuelBayViewEnum;
        return this;
    }

    public CorporationStarbaseResponse fuelBayViewString(String fuelBayView) {
        this.fuelBayView = fuelBayView;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can view the starbase (POS)'s fule bay. Characters either need to have required role or belong to the starbase (POS) owner's corporation or alliance, as described by the enum, all other access settings follows the same scheme")
    public FuelBayViewEnum getFuelBayView() {
        if (this.fuelBayViewEnum == null) {
            this.fuelBayViewEnum = FuelBayViewEnum.fromValue(this.fuelBayView);
        }
        return this.fuelBayViewEnum;
    }

    public String getFuelBayViewString() {
        return this.fuelBayView;
    }

    public void setFuelBayView(FuelBayViewEnum fuelBayViewEnum) {
        this.fuelBayViewEnum = fuelBayViewEnum;
    }

    public void setFuelBayViewString(String fuelBayView) {
        this.fuelBayView = fuelBayView;
    }

    public CorporationStarbaseResponse fuels(List<CorporationStarbaseFuel> fuels) {
        this.fuels = fuels;
        return this;
    }

    public CorporationStarbaseResponse addFuelsItem(CorporationStarbaseFuel fuelsItem) {
        if (this.fuels == null) {
            this.fuels = new ArrayList<CorporationStarbaseFuel>();
        }
        this.fuels.add(fuelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Fuel blocks and other things that will be consumed when operating a starbase (POS)")
    public List<CorporationStarbaseFuel> getFuels() {
        return this.fuels;
    }

    public void setFuels(List<CorporationStarbaseFuel> fuels) {
        this.fuels = fuels;
    }

    public CorporationStarbaseResponse offline(OfflineEnum offlineEnum) {
        this.offlineEnum = offlineEnum;
        return this;
    }

    public CorporationStarbaseResponse offlineString(String offline) {
        this.offline = offline;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can offline starbase (POS) and its structures")
    public OfflineEnum getOffline() {
        if (this.offlineEnum == null) {
            this.offlineEnum = OfflineEnum.fromValue(this.offline);
        }
        return this.offlineEnum;
    }

    public String getOfflineString() {
        return this.offline;
    }

    public void setOffline(OfflineEnum offlineEnum) {
        this.offlineEnum = offlineEnum;
    }

    public void setOfflineString(String offline) {
        this.offline = offline;
    }

    public CorporationStarbaseResponse online(OnlineEnum onlineEnum) {
        this.onlineEnum = onlineEnum;
        return this;
    }

    public CorporationStarbaseResponse onlineString(String online) {
        this.online = online;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can online starbase (POS) and its structures")
    public OnlineEnum getOnline() {
        if (this.onlineEnum == null) {
            this.onlineEnum = OnlineEnum.fromValue(this.online);
        }
        return this.onlineEnum;
    }

    public String getOnlineString() {
        return this.online;
    }

    public void setOnline(OnlineEnum onlineEnum) {
        this.onlineEnum = onlineEnum;
    }

    public void setOnlineString(String online) {
        this.online = online;
    }

    public CorporationStarbaseResponse unanchor(UnanchorEnum unanchorEnum) {
        this.unanchorEnum = unanchorEnum;
        return this;
    }

    public CorporationStarbaseResponse unanchorString(String unanchor) {
        this.unanchor = unanchor;
        return this;
    }

    @ApiModelProperty(required=true, value="Who can unanchor starbase (POS) and its structures")
    public UnanchorEnum getUnanchor() {
        if (this.unanchorEnum == null) {
            this.unanchorEnum = UnanchorEnum.fromValue(this.unanchor);
        }
        return this.unanchorEnum;
    }

    public String getUnanchorString() {
        return this.unanchor;
    }

    public void setUnanchor(UnanchorEnum unanchorEnum) {
        this.unanchorEnum = unanchorEnum;
    }

    public void setUnanchorString(String unanchor) {
        this.unanchor = unanchor;
    }

    public CorporationStarbaseResponse useAllianceStandings(Boolean useAllianceStandings) {
        this.useAllianceStandings = useAllianceStandings;
        return this;
    }

    @ApiModelProperty(required=true, value="True if the starbase (POS) is using alliance standings, otherwise using corporation's")
    public Boolean getUseAllianceStandings() {
        return this.useAllianceStandings;
    }

    public void setUseAllianceStandings(Boolean useAllianceStandings) {
        this.useAllianceStandings = useAllianceStandings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporationStarbaseResponse corporationStarbaseResponse = (CorporationStarbaseResponse)o;
        return Objects.equals(this.allowAllianceMembers, corporationStarbaseResponse.allowAllianceMembers) && Objects.equals(this.allowCorporationMembers, corporationStarbaseResponse.allowCorporationMembers) && Objects.equals(this.anchor, corporationStarbaseResponse.anchor) && Objects.equals(this.attackIfAtWar, corporationStarbaseResponse.attackIfAtWar) && Objects.equals(this.attackIfOtherSecurityStatusDropping, corporationStarbaseResponse.attackIfOtherSecurityStatusDropping) && Objects.equals(this.attackSecurityStatusThreshold, corporationStarbaseResponse.attackSecurityStatusThreshold) && Objects.equals(this.attackStandingThreshold, corporationStarbaseResponse.attackStandingThreshold) && Objects.equals(this.fuelBayTake, corporationStarbaseResponse.fuelBayTake) && Objects.equals(this.fuelBayView, corporationStarbaseResponse.fuelBayView) && Objects.equals(this.fuels, corporationStarbaseResponse.fuels) && Objects.equals(this.offline, corporationStarbaseResponse.offline) && Objects.equals(this.online, corporationStarbaseResponse.online) && Objects.equals(this.unanchor, corporationStarbaseResponse.unanchor) && Objects.equals(this.useAllianceStandings, corporationStarbaseResponse.useAllianceStandings);
    }

    public int hashCode() {
        return Objects.hash(this.allowAllianceMembers, this.allowCorporationMembers, this.anchor, this.attackIfAtWar, this.attackIfOtherSecurityStatusDropping, this.attackSecurityStatusThreshold, this.attackStandingThreshold, this.fuelBayTake, this.fuelBayView, this.fuels, this.offline, this.online, this.unanchor, this.useAllianceStandings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStarbaseResponse {\n");
        sb.append("    allowAllianceMembers: ").append(this.toIndentedString(this.allowAllianceMembers)).append("\n");
        sb.append("    allowCorporationMembers: ").append(this.toIndentedString(this.allowCorporationMembers)).append("\n");
        sb.append("    anchor: ").append(this.toIndentedString(this.anchor)).append("\n");
        sb.append("    attackIfAtWar: ").append(this.toIndentedString(this.attackIfAtWar)).append("\n");
        sb.append("    attackIfOtherSecurityStatusDropping: ").append(this.toIndentedString(this.attackIfOtherSecurityStatusDropping)).append("\n");
        sb.append("    attackSecurityStatusThreshold: ").append(this.toIndentedString(this.attackSecurityStatusThreshold)).append("\n");
        sb.append("    attackStandingThreshold: ").append(this.toIndentedString(this.attackStandingThreshold)).append("\n");
        sb.append("    fuelBayTake: ").append(this.toIndentedString(this.fuelBayTake)).append("\n");
        sb.append("    fuelBayView: ").append(this.toIndentedString(this.fuelBayView)).append("\n");
        sb.append("    fuels: ").append(this.toIndentedString(this.fuels)).append("\n");
        sb.append("    offline: ").append(this.toIndentedString(this.offline)).append("\n");
        sb.append("    online: ").append(this.toIndentedString(this.online)).append("\n");
        sb.append("    unanchor: ").append(this.toIndentedString(this.unanchor)).append("\n");
        sb.append("    useAllianceStandings: ").append(this.toIndentedString(this.useAllianceStandings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UnanchorEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private UnanchorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UnanchorEnum fromValue(String value) {
            for (UnanchorEnum b : UnanchorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<UnanchorEnum> {
            public void write(JsonWriter jsonWriter, UnanchorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UnanchorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UnanchorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OnlineEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private OnlineEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OnlineEnum fromValue(String value) {
            for (OnlineEnum b : OnlineEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OnlineEnum> {
            public void write(JsonWriter jsonWriter, OnlineEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OnlineEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OnlineEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OfflineEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private OfflineEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OfflineEnum fromValue(String value) {
            for (OfflineEnum b : OfflineEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OfflineEnum> {
            public void write(JsonWriter jsonWriter, OfflineEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OfflineEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OfflineEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FuelBayViewEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private FuelBayViewEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FuelBayViewEnum fromValue(String value) {
            for (FuelBayViewEnum b : FuelBayViewEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FuelBayViewEnum> {
            public void write(JsonWriter jsonWriter, FuelBayViewEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FuelBayViewEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FuelBayViewEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FuelBayTakeEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private FuelBayTakeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FuelBayTakeEnum fromValue(String value) {
            for (FuelBayTakeEnum b : FuelBayTakeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FuelBayTakeEnum> {
            public void write(JsonWriter jsonWriter, FuelBayTakeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FuelBayTakeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FuelBayTakeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AnchorEnum {
        ALLIANCE_MEMBER("alliance_member"),
        CONFIG_STARBASE_EQUIPMENT_ROLE("config_starbase_equipment_role"),
        CORPORATION_MEMBER("corporation_member"),
        STARBASE_FUEL_TECHNICIAN_ROLE("starbase_fuel_technician_role");

        private String value;

        private AnchorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AnchorEnum fromValue(String value) {
            for (AnchorEnum b : AnchorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AnchorEnum> {
            public void write(JsonWriter jsonWriter, AnchorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AnchorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AnchorEnum.fromValue(value);
            }
        }
    }
}

