/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 1.8.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CharacterPlanetsResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_LAST_UPDATE = "last_update";
    @SerializedName(SERIALIZED_NAME_LAST_UPDATE)
    private OffsetDateTime lastUpdate;

    public static final String SERIALIZED_NAME_NUM_PINS = "num_pins";
    @SerializedName(SERIALIZED_NAME_NUM_PINS)
    private Integer numPins;

    public static final String SERIALIZED_NAME_OWNER_ID = "owner_id";
    @SerializedName(SERIALIZED_NAME_OWNER_ID)
    private Integer ownerId;

    public static final String SERIALIZED_NAME_PLANET_ID = "planet_id";
    @SerializedName(SERIALIZED_NAME_PLANET_ID)
    private Integer planetId;

    /**
     * planet_type string
     */
    @JsonAdapter(PlanetTypeEnum.Adapter.class)
    public enum PlanetTypeEnum {
        TEMPERATE("temperate"),

        BARREN("barren"),

        OCEANIC("oceanic"),

        ICE("ice"),

        GAS("gas"),

        LAVA("lava"),

        STORM("storm"),

        PLASMA("plasma");

        private String value;

        PlanetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static PlanetTypeEnum fromValue(String value) {
            for (PlanetTypeEnum b : PlanetTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return null;
        }

        public static class Adapter extends TypeAdapter<PlanetTypeEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final PlanetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public PlanetTypeEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlanetTypeEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_PLANET_TYPE = "planet_type";
    @SerializedName(SERIALIZED_NAME_PLANET_TYPE)
    private String planetType;
    private PlanetTypeEnum planetTypeEnum;

    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(SERIALIZED_NAME_SOLAR_SYSTEM_ID)
    private Integer solarSystemId;

    public static final String SERIALIZED_NAME_UPGRADE_LEVEL = "upgrade_level";
    @SerializedName(SERIALIZED_NAME_UPGRADE_LEVEL)
    private Integer upgradeLevel;

    public CharacterPlanetsResponse lastUpdate(OffsetDateTime lastUpdate) {

        this.lastUpdate = lastUpdate;
        return this;
    }

    /**
     * last_update string
     * 
     * @return lastUpdate
     **/
    @ApiModelProperty(required = true, value = "last_update string")
    public OffsetDateTime getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public CharacterPlanetsResponse numPins(Integer numPins) {

        this.numPins = numPins;
        return this;
    }

    /**
     * num_pins integer minimum: 1
     * 
     * @return numPins
     **/
    @ApiModelProperty(required = true, value = "num_pins integer")
    public Integer getNumPins() {
        return numPins;
    }

    public void setNumPins(Integer numPins) {
        this.numPins = numPins;
    }

    public CharacterPlanetsResponse ownerId(Integer ownerId) {

        this.ownerId = ownerId;
        return this;
    }

    /**
     * owner_id integer
     * 
     * @return ownerId
     **/
    @ApiModelProperty(required = true, value = "owner_id integer")
    public Integer getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Integer ownerId) {
        this.ownerId = ownerId;
    }

    public CharacterPlanetsResponse planetId(Integer planetId) {

        this.planetId = planetId;
        return this;
    }

    /**
     * planet_id integer
     * 
     * @return planetId
     **/
    @ApiModelProperty(required = true, value = "planet_id integer")
    public Integer getPlanetId() {
        return planetId;
    }

    public void setPlanetId(Integer planetId) {
        this.planetId = planetId;
    }

    public CharacterPlanetsResponse planetType(PlanetTypeEnum planetTypeEnum) {

        this.planetTypeEnum = planetTypeEnum;
        return this;
    }

    public CharacterPlanetsResponse planetTypeString(String planetType) {

        this.planetType = planetType;
        return this;
    }

    /**
     * planet_type string
     * 
     * @return planetType
     **/
    @ApiModelProperty(required = true, value = "planet_type string")
    public PlanetTypeEnum getPlanetType() {
        if (planetTypeEnum == null) {
            planetTypeEnum = PlanetTypeEnum.fromValue(planetType);
        }
        return planetTypeEnum;
    }

    public String getPlanetTypeString() {
        return planetType;
    }

    public void setPlanetType(PlanetTypeEnum planetTypeEnum) {
        this.planetTypeEnum = planetTypeEnum;
    }

    public void setPlanetTypeString(String planetType) {
        this.planetType = planetType;
    }

    public CharacterPlanetsResponse solarSystemId(Integer solarSystemId) {

        this.solarSystemId = solarSystemId;
        return this;
    }

    /**
     * solar_system_id integer
     * 
     * @return solarSystemId
     **/
    @ApiModelProperty(required = true, value = "solar_system_id integer")
    public Integer getSolarSystemId() {
        return solarSystemId;
    }

    public void setSolarSystemId(Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public CharacterPlanetsResponse upgradeLevel(Integer upgradeLevel) {

        this.upgradeLevel = upgradeLevel;
        return this;
    }

    /**
     * upgrade_level integer minimum: 0 maximum: 5
     * 
     * @return upgradeLevel
     **/
    @ApiModelProperty(required = true, value = "upgrade_level integer")
    public Integer getUpgradeLevel() {
        return upgradeLevel;
    }

    public void setUpgradeLevel(Integer upgradeLevel) {
        this.upgradeLevel = upgradeLevel;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CharacterPlanetsResponse characterPlanetsResponse = (CharacterPlanetsResponse) o;
        return Objects.equals(this.lastUpdate, characterPlanetsResponse.lastUpdate)
                && Objects.equals(this.numPins, characterPlanetsResponse.numPins)
                && Objects.equals(this.ownerId, characterPlanetsResponse.ownerId)
                && Objects.equals(this.planetId, characterPlanetsResponse.planetId)
                && Objects.equals(this.planetType, characterPlanetsResponse.planetType)
                && Objects.equals(this.solarSystemId, characterPlanetsResponse.solarSystemId)
                && Objects.equals(this.upgradeLevel, characterPlanetsResponse.upgradeLevel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lastUpdate, numPins, ownerId, planetId, planetType, solarSystemId, upgradeLevel);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterPlanetsResponse {\n");
        sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
        sb.append("    numPins: ").append(toIndentedString(numPins)).append("\n");
        sb.append("    ownerId: ").append(toIndentedString(ownerId)).append("\n");
        sb.append("    planetId: ").append(toIndentedString(planetId)).append("\n");
        sb.append("    planetType: ").append(toIndentedString(planetType)).append("\n");
        sb.append("    solarSystemId: ").append(toIndentedString(solarSystemId)).append("\n");
        sb.append("    upgradeLevel: ").append(toIndentedString(upgradeLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
