/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.troja.eve.esi.model.FactionWarfareLeaderboardActiveTotalKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardLastWeekKills;
import net.troja.eve.esi.model.FactionWarfareLeaderboardYesterdayKills;

@ApiModel(description="Top 4 rankings of factions by number of kills from yesterday, last week and in total")
public class FactionWarfareLeaderboardKills
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACTIVE_TOTAL = "active_total";
    @SerializedName(value="active_total")
    private List<FactionWarfareLeaderboardActiveTotalKills> activeTotal = new ArrayList<FactionWarfareLeaderboardActiveTotalKills>();
    public static final String SERIALIZED_NAME_LAST_WEEK = "last_week";
    @SerializedName(value="last_week")
    private List<FactionWarfareLeaderboardLastWeekKills> lastWeek = new ArrayList<FactionWarfareLeaderboardLastWeekKills>();
    public static final String SERIALIZED_NAME_YESTERDAY = "yesterday";
    @SerializedName(value="yesterday")
    private List<FactionWarfareLeaderboardYesterdayKills> yesterday = new ArrayList<FactionWarfareLeaderboardYesterdayKills>();

    public FactionWarfareLeaderboardKills activeTotal(List<FactionWarfareLeaderboardActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
        return this;
    }

    public FactionWarfareLeaderboardKills addActiveTotalItem(FactionWarfareLeaderboardActiveTotalKills activeTotalItem) {
        this.activeTotal.add(activeTotalItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions active in faction warfare by total kills. A faction is considered \"active\" if they have participated in faction warfare in the past 14 days")
    public List<FactionWarfareLeaderboardActiveTotalKills> getActiveTotal() {
        return this.activeTotal;
    }

    public void setActiveTotal(List<FactionWarfareLeaderboardActiveTotalKills> activeTotal) {
        this.activeTotal = activeTotal;
    }

    public FactionWarfareLeaderboardKills lastWeek(List<FactionWarfareLeaderboardLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
        return this;
    }

    public FactionWarfareLeaderboardKills addLastWeekItem(FactionWarfareLeaderboardLastWeekKills lastWeekItem) {
        this.lastWeek.add(lastWeekItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions by kills in the past week")
    public List<FactionWarfareLeaderboardLastWeekKills> getLastWeek() {
        return this.lastWeek;
    }

    public void setLastWeek(List<FactionWarfareLeaderboardLastWeekKills> lastWeek) {
        this.lastWeek = lastWeek;
    }

    public FactionWarfareLeaderboardKills yesterday(List<FactionWarfareLeaderboardYesterdayKills> yesterday) {
        this.yesterday = yesterday;
        return this;
    }

    public FactionWarfareLeaderboardKills addYesterdayItem(FactionWarfareLeaderboardYesterdayKills yesterdayItem) {
        this.yesterday.add(yesterdayItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Top 4 ranking of factions by kills in the past day")
    public List<FactionWarfareLeaderboardYesterdayKills> getYesterday() {
        return this.yesterday;
    }

    public void setYesterday(List<FactionWarfareLeaderboardYesterdayKills> yesterday) {
        this.yesterday = yesterday;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FactionWarfareLeaderboardKills factionWarfareLeaderboardKills = (FactionWarfareLeaderboardKills)o;
        return Objects.equals(this.activeTotal, factionWarfareLeaderboardKills.activeTotal) && Objects.equals(this.lastWeek, factionWarfareLeaderboardKills.lastWeek) && Objects.equals(this.yesterday, factionWarfareLeaderboardKills.yesterday);
    }

    public int hashCode() {
        return Objects.hash(this.activeTotal, this.lastWeek, this.yesterday);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FactionWarfareLeaderboardKills {\n");
        sb.append("    activeTotal: ").append(this.toIndentedString(this.activeTotal)).append("\n");
        sb.append("    lastWeek: ").append(this.toIndentedString(this.lastWeek)).append("\n");
        sb.append("    yesterday: ").append(this.toIndentedString(this.yesterday)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

