/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="movement object")
public class FleetMemberMovement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    private String role;
    private RoleEnum roleEnum;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    private Long squadId;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    private Long wingId;

    public FleetMemberMovement role(RoleEnum roleEnum) {
        this.roleEnum = roleEnum;
        return this;
    }

    public FleetMemberMovement roleString(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(required=true, value="If a character is moved to the `fleet_commander` role, neither `wing_id` or `squad_id` should be specified. If a character is moved to the `wing_commander` role, only `wing_id` should be specified. If a character is moved to the `squad_commander` role, both `wing_id` and `squad_id` should be specified. If a character is moved to the `squad_member` role, both `wing_id` and `squad_id` should be specified.")
    public RoleEnum getRole() {
        if (this.roleEnum == null) {
            this.roleEnum = RoleEnum.fromValue(this.role);
        }
        return this.roleEnum;
    }

    public String getRoleString() {
        return this.role;
    }

    public void setRole(RoleEnum roleEnum) {
        this.roleEnum = roleEnum;
    }

    public void setRoleString(String role) {
        this.role = role;
    }

    public FleetMemberMovement squadId(Long squadId) {
        this.squadId = squadId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="squad_id integer")
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(Long squadId) {
        this.squadId = squadId;
    }

    public FleetMemberMovement wingId(Long wingId) {
        this.wingId = wingId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="wing_id integer")
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(Long wingId) {
        this.wingId = wingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetMemberMovement fleetMemberMovement = (FleetMemberMovement)o;
        return Objects.equals(this.role, fleetMemberMovement.role) && Objects.equals(this.squadId, fleetMemberMovement.squadId) && Objects.equals(this.wingId, fleetMemberMovement.wingId);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.squadId, this.wingId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetMemberMovement {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        sb.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

