/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="200 ok object")
public class CorporationStarbasesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_MOON_ID = "moon_id";
    @SerializedName(value="moon_id")
    private Integer moonId;
    public static final String SERIALIZED_NAME_ONLINED_SINCE = "onlined_since";
    @SerializedName(value="onlined_since")
    private OffsetDateTime onlinedSince;
    public static final String SERIALIZED_NAME_REINFORCED_UNTIL = "reinforced_until";
    @SerializedName(value="reinforced_until")
    private OffsetDateTime reinforcedUntil;
    public static final String SERIALIZED_NAME_STARBASE_ID = "starbase_id";
    @SerializedName(value="starbase_id")
    private Long starbaseId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    private StateEnum stateEnum;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    private Integer systemId;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    private Integer typeId;
    public static final String SERIALIZED_NAME_UNANCHOR_AT = "unanchor_at";
    @SerializedName(value="unanchor_at")
    private OffsetDateTime unanchorAt;

    public CorporationStarbasesResponse moonId(Integer moonId) {
        this.moonId = moonId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The moon this starbase (POS) is anchored on, unanchored POSes do not have this information")
    public Integer getMoonId() {
        return this.moonId;
    }

    public void setMoonId(Integer moonId) {
        this.moonId = moonId;
    }

    public CorporationStarbasesResponse onlinedSince(OffsetDateTime onlinedSince) {
        this.onlinedSince = onlinedSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the POS onlined, for starbases (POSes) in online state")
    public OffsetDateTime getOnlinedSince() {
        return this.onlinedSince;
    }

    public void setOnlinedSince(OffsetDateTime onlinedSince) {
        this.onlinedSince = onlinedSince;
    }

    public CorporationStarbasesResponse reinforcedUntil(OffsetDateTime reinforcedUntil) {
        this.reinforcedUntil = reinforcedUntil;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the POS will be out of reinforcement, for starbases (POSes) in reinforced state")
    public OffsetDateTime getReinforcedUntil() {
        return this.reinforcedUntil;
    }

    public void setReinforcedUntil(OffsetDateTime reinforcedUntil) {
        this.reinforcedUntil = reinforcedUntil;
    }

    public CorporationStarbasesResponse starbaseId(Long starbaseId) {
        this.starbaseId = starbaseId;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique ID for this starbase (POS)")
    public Long getStarbaseId() {
        return this.starbaseId;
    }

    public void setStarbaseId(Long starbaseId) {
        this.starbaseId = starbaseId;
    }

    public CorporationStarbasesResponse state(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
        return this;
    }

    public CorporationStarbasesResponse stateString(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="state string")
    public StateEnum getState() {
        if (this.stateEnum == null) {
            this.stateEnum = StateEnum.fromValue(this.state);
        }
        return this.stateEnum;
    }

    public String getStateString() {
        return this.state;
    }

    public void setState(StateEnum stateEnum) {
        this.stateEnum = stateEnum;
    }

    public void setStateString(String state) {
        this.state = state;
    }

    public CorporationStarbasesResponse systemId(Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The solar system this starbase (POS) is in, unanchored POSes have this information")
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Integer systemId) {
        this.systemId = systemId;
    }

    public CorporationStarbasesResponse typeId(Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(required=true, value="Starbase (POS) type")
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer typeId) {
        this.typeId = typeId;
    }

    public CorporationStarbasesResponse unanchorAt(OffsetDateTime unanchorAt) {
        this.unanchorAt = unanchorAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the POS started unanchoring, for starbases (POSes) in unanchoring state")
    public OffsetDateTime getUnanchorAt() {
        return this.unanchorAt;
    }

    public void setUnanchorAt(OffsetDateTime unanchorAt) {
        this.unanchorAt = unanchorAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CorporationStarbasesResponse corporationStarbasesResponse = (CorporationStarbasesResponse)o;
        return Objects.equals(this.moonId, corporationStarbasesResponse.moonId) && Objects.equals(this.onlinedSince, corporationStarbasesResponse.onlinedSince) && Objects.equals(this.reinforcedUntil, corporationStarbasesResponse.reinforcedUntil) && Objects.equals(this.starbaseId, corporationStarbasesResponse.starbaseId) && Objects.equals(this.state, corporationStarbasesResponse.state) && Objects.equals(this.systemId, corporationStarbasesResponse.systemId) && Objects.equals(this.typeId, corporationStarbasesResponse.typeId) && Objects.equals(this.unanchorAt, corporationStarbasesResponse.unanchorAt);
    }

    public int hashCode() {
        return Objects.hash(this.moonId, this.onlinedSince, this.reinforcedUntil, this.starbaseId, this.state, this.systemId, this.typeId, this.unanchorAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationStarbasesResponse {\n");
        sb.append("    moonId: ").append(this.toIndentedString(this.moonId)).append("\n");
        sb.append("    onlinedSince: ").append(this.toIndentedString(this.onlinedSince)).append("\n");
        sb.append("    reinforcedUntil: ").append(this.toIndentedString(this.reinforcedUntil)).append("\n");
        sb.append("    starbaseId: ").append(this.toIndentedString(this.starbaseId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    unanchorAt: ").append(this.toIndentedString(this.unanchorAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        OFFLINE("offline"),
        ONLINE("online"),
        ONLINING("onlining"),
        REINFORCED("reinforced"),
        UNANCHORING("unanchoring");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

