/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.troja.eve.esi.ApiCallback;
import net.troja.eve.esi.ApiClient;
import net.troja.eve.esi.ApiException;
import net.troja.eve.esi.ApiResponse;
import net.troja.eve.esi.Configuration;
import net.troja.eve.esi.Pair;
import net.troja.eve.esi.model.CharacterSearchResponse;
import net.troja.eve.esi.model.SearchResponse;
import okhttp3.Call;

public class SearchApi {
    private ApiClient localVarApiClient;

    public SearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getCharactersCharacterIdSearchCall(List<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v3/characters/{character_id}/search/".replaceAll("\\{character_id\\}", this.localVarApiClient.escapeString(characterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (categories != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "categories", categories));
        }
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (strict != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("strict", strict));
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"evesso"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCharactersCharacterIdSearchValidateBeforeCall(List<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback _callback) throws ApiException {
        if (categories == null) {
            throw new ApiException("Missing the required parameter 'categories' when calling getCharactersCharacterIdSearch(Async)");
        }
        if (characterId == null) {
            throw new ApiException("Missing the required parameter 'characterId' when calling getCharactersCharacterIdSearch(Async)");
        }
        if (search == null) {
            throw new ApiException("Missing the required parameter 'search' when calling getCharactersCharacterIdSearch(Async)");
        }
        Call localVarCall = this.getCharactersCharacterIdSearchCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, _callback);
        return localVarCall;
    }

    public CharacterSearchResponse getCharactersCharacterIdSearch(List<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token) throws ApiException {
        ApiResponse<CharacterSearchResponse> localVarResp = this.getCharactersCharacterIdSearchWithHttpInfo(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token);
        return localVarResp.getData();
    }

    public ApiResponse<CharacterSearchResponse> getCharactersCharacterIdSearchWithHttpInfo(List<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, null);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCharactersCharacterIdSearchAsync(List<String> categories, Integer characterId, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, String token, ApiCallback<CharacterSearchResponse> _callback) throws ApiException {
        Call localVarCall = this.getCharactersCharacterIdSearchValidateBeforeCall(categories, characterId, search, acceptLanguage, datasource, ifNoneMatch, language, strict, token, _callback);
        Type localVarReturnType = new TypeToken<CharacterSearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSearchCall(List<String> categories, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v2/search/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (categories != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("csv", "categories", categories));
        }
        if (datasource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("datasource", datasource));
        }
        if (language != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("language", language));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (strict != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("strict", strict));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.localVarApiClient.parameterToString(acceptLanguage));
        }
        if (ifNoneMatch != null) {
            localVarHeaderParams.put("If-None-Match", this.localVarApiClient.parameterToString(ifNoneMatch));
        }
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSearchValidateBeforeCall(List<String> categories, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, ApiCallback _callback) throws ApiException {
        if (categories == null) {
            throw new ApiException("Missing the required parameter 'categories' when calling getSearch(Async)");
        }
        if (search == null) {
            throw new ApiException("Missing the required parameter 'search' when calling getSearch(Async)");
        }
        Call localVarCall = this.getSearchCall(categories, search, acceptLanguage, datasource, ifNoneMatch, language, strict, _callback);
        return localVarCall;
    }

    public SearchResponse getSearch(List<String> categories, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict) throws ApiException {
        ApiResponse<SearchResponse> localVarResp = this.getSearchWithHttpInfo(categories, search, acceptLanguage, datasource, ifNoneMatch, language, strict);
        return localVarResp.getData();
    }

    public ApiResponse<SearchResponse> getSearchWithHttpInfo(List<String> categories, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict) throws ApiException {
        Call localVarCall = this.getSearchValidateBeforeCall(categories, search, acceptLanguage, datasource, ifNoneMatch, language, strict, null);
        Type localVarReturnType = new TypeToken<SearchResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSearchAsync(List<String> categories, String search, String acceptLanguage, String datasource, String ifNoneMatch, String language, Boolean strict, ApiCallback<SearchResponse> _callback) throws ApiException {
        Call localVarCall = this.getSearchValidateBeforeCall(categories, search, acceptLanguage, datasource, ifNoneMatch, language, strict, _callback);
        Type localVarReturnType = new TypeToken<SearchResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

