/*
 * EVE Swagger Interface
 * An OpenAPI for EVE Online
 *
 * The version of the OpenAPI document: 1.7.15
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package net.troja.eve.esi.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.io.Serializable;

/**
 * 200 ok object
 */
@ApiModel(description = "200 ok object")
public class CorporationMiningObserversResponse implements Serializable {
    private static final long serialVersionUID = 1L;

    public static final String SERIALIZED_NAME_LAST_UPDATED = "last_updated";
    @SerializedName(SERIALIZED_NAME_LAST_UPDATED)
    private LocalDate lastUpdated;

    public static final String SERIALIZED_NAME_OBSERVER_ID = "observer_id";
    @SerializedName(SERIALIZED_NAME_OBSERVER_ID)
    private Long observerId;

    /**
     * The category of the observing entity
     */
    @JsonAdapter(ObserverTypeEnum.Adapter.class)
    public enum ObserverTypeEnum {
        STRUCTURE("structure");

        private String value;

        ObserverTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        public static ObserverTypeEnum fromValue(String value) {
            for (ObserverTypeEnum b : ObserverTypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return null;
        }

        public static class Adapter extends TypeAdapter<ObserverTypeEnum> {
            @Override
            public void write(final JsonWriter jsonWriter, final ObserverTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public ObserverTypeEnum read(final JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ObserverTypeEnum.fromValue(value);
            }
        }
    }

    public static final String SERIALIZED_NAME_OBSERVER_TYPE = "observer_type";
    @SerializedName(SERIALIZED_NAME_OBSERVER_TYPE)
    private String observerType;
    private ObserverTypeEnum observerTypeEnum;

    public CorporationMiningObserversResponse lastUpdated(LocalDate lastUpdated) {

        this.lastUpdated = lastUpdated;
        return this;
    }

    /**
     * last_updated string
     * 
     * @return lastUpdated
     **/
    @ApiModelProperty(required = true, value = "last_updated string")
    public LocalDate getLastUpdated() {
        return lastUpdated;
    }

    public void setLastUpdated(LocalDate lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public CorporationMiningObserversResponse observerId(Long observerId) {

        this.observerId = observerId;
        return this;
    }

    /**
     * The entity that was observing the asteroid field when it was mined.
     * 
     * @return observerId
     **/
    @ApiModelProperty(required = true, value = "The entity that was observing the asteroid field when it was mined. ")
    public Long getObserverId() {
        return observerId;
    }

    public void setObserverId(Long observerId) {
        this.observerId = observerId;
    }

    public CorporationMiningObserversResponse observerType(ObserverTypeEnum observerTypeEnum) {

        this.observerTypeEnum = observerTypeEnum;
        return this;
    }

    public CorporationMiningObserversResponse observerTypeString(String observerType) {

        this.observerType = observerType;
        return this;
    }

    /**
     * The category of the observing entity
     * 
     * @return observerType
     **/
    @ApiModelProperty(required = true, value = "The category of the observing entity")
    public ObserverTypeEnum getObserverType() {
        if (observerTypeEnum == null) {
            observerTypeEnum = ObserverTypeEnum.fromValue(observerType);
        }
        return observerTypeEnum;
    }

    public String getObserverTypeString() {
        return observerType;
    }

    public void setObserverType(ObserverTypeEnum observerTypeEnum) {
        this.observerTypeEnum = observerTypeEnum;
    }

    public void setObserverTypeString(String observerType) {
        this.observerType = observerType;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CorporationMiningObserversResponse corporationMiningObserversResponse = (CorporationMiningObserversResponse) o;
        return Objects.equals(this.lastUpdated, corporationMiningObserversResponse.lastUpdated)
                && Objects.equals(this.observerId, corporationMiningObserversResponse.observerId)
                && Objects.equals(this.observerType, corporationMiningObserversResponse.observerType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(lastUpdated, observerId, observerType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CorporationMiningObserversResponse {\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    observerId: ").append(toIndentedString(observerId)).append("\n");
        sb.append("    observerType: ").append(toIndentedString(observerType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
